{$E-}{$N-}
uses Graph;
type DataArray = array [1..1000] of Real;
const NColor=15;
var X, Y, Vx, Vy, P: DataArray;
    XC, YC, I, J, K, L, N, N1, N2, NP, W: Word;
    GD, GM, Err: Integer;
    F: Text;
    S, S1, S2: string;
    MinP, MaxP, DP, MaxX, MaxY, MaxV, sc, scV, VLen, DAVL: Real;

procedure Reset (var F: Text;  Msg: string);
begin
   {$I-} System.Reset(F); {$I+}
   if IOResult<>0 then begin
      WriteLn(Msg);
      Halt;
   end;
end;

procedure ReadFile (var F: Text;  N: Word;  var X: DataArray;  Msg: string);
var I: Word;  S: string;
begin
   {$I-}
   for I:=1 to N do  begin
      ReadLn(F,S);
      Val(S,X[I],Err);
      if ((IOResult<>0)or(Err<>0)) then begin
         WriteLn(Msg);
         Halt;
      end;
   end;
   {$I+}
end;

procedure LoadData(var X: DataArray;  S: string;  N: Word);
begin
   Assign(F,S);
   Reset(F,'H   䠩 '+S);
   ReadFile (F,N,X,'訡  䠩 '+S);
   Close(F);
end;

begin
{  樠 䨪}
   GD:=VGA; GM:=VGAHi;
   InitGraph(GD,GM,'');
   SetBkColor(White); SetColor(Black);
{  । ᥣ }
   W:=Trunc(640/NColor)-5;
   LoadData(X,'Node.Dat',4);
   N1:=Round(X[1]+1);
   N2:=Round(X[2]+1);
   VLen:=Round(X[3]);
   DAVL:=Round(X[4]);
   N:=N1*N2;
   NP:=(N1-1)*(N2-1);
{  㧪  }
   LoadData(X,'Coord_X.Dat',N);
   LoadData(Y,'Coord_Y.Dat',N);
   LoadData(Vx,'Velos_X.Dat',N);
   LoadData(Vy,'Velos_Y.Dat',N);
   LoadData(P,'Pressure.Dat',NP);
{  H宦 ⠡ 뢮 ⪨ न  ५ ஢ ᪮}
   MaxX :=X[1];
   MaxY :=Y[1];
   MaxV:=Vy[1];
   for I:=1 to N do  begin
      if X[I]>MaxX then MaxX:=X[I];
      if Y[I]>MaxY then MaxY:=Y[I];
      if Abs(Vy[I])>MaxV then MaxV:=Abs(Vy[I]);
      if Abs(Vx[I])>MaxV then MaxV:=Abs(Vx[I]);
   end;
   if 600/MaxX<400/MaxY then sc:=600/MaxX else sc:=400/MaxY;
   scV:=VLen/MaxV;
   SetColor(LightBlue);
   for I:=1 to N1 do
      for J:=1 to N2 do  begin
         MoveTo (Round(X[(I-1)*N2+J]*sc),400-Round(Y[(I-1)*N2+J]*sc));
         LineRel (Round(Vx[(I-1)*N2+J]*scV),Round(-Vy[(I-1)*N2+J]*scV));
         PutPixel(GetX,GetY,Black);
      end;
   Line(320,0,320,480);
   SetColor(LightRed);
   MoveTo( Round(X[1]*sc), 400-Round(Y[1]*sc) );
   for J:=2 to N2 do
      LineTo( Round(X[(J-1)*N1+1]*sc), 400-Round(Y[(J-1)*N1+1]*sc) );
   ReadLn; ReadLn;
{   뢮 -⪨}
   ClearDevice; SetBkColor(White); SetColor(Black);
   SetColor(LightRed);
   for I:=1 to N1 do  begin
      MoveTo( Round(X[I]*sc), 400-Round(Y[I]*sc) );
      for J:=2 to N2 do
         LineTo( Round(X[(J-1)*N1+I]*sc), 400-Round(Y[(J-1)*N1+I]*sc) );
   end;
   for J:=1 to N2 do  begin
      MoveTo( Round(X[(J-1)*N1+1]*sc), 400-Round(Y[(J-1)*N1+1]*sc) );
      for I:=2 to N1 do
         LineTo( Round(X[(J-1)*N1+I]*sc), 400-Round(Y[(J-1)*N1+I]*sc) );
   end;
{  । 誠 }
   for I:=1 to NP do  P[I]:=-P[I];
   MinP:=P[1];
   MaxP:=P[1];
   for I:=1 to NP do  begin
      if P[I]<MinP then MinP:=P[I];
      if P[I]>MaxP then MaxP:=P[I];
   end;
   DP:=(MaxP-MinP)/NColor;
{  뢮 誠 }
   for K:=0 to NColor do  begin
      SetFillStyle(1,K);
      if K>0 then Bar(K*W,420,(K+1)*W-10,450);
      Str(MinP+DP*K:5,S);
      if Odd(K) then OutTextXY(K*W,460,S) else OutTextXY(K*W,410,S)
   end;
{  뢮 }
   for J:=1 to N2-1 do  begin
      for I:=1 to N1-1 do  begin
         L:=(J-1)*N1+I;
         XC:=Trunc((X[(J-1)*N1+I]+X[(J-1)*N1+I+1]+X[J*N1+I]+X[J*N1+I+1])/4*sc);
         YC:=400-Trunc((Y[(J-1)*N1+I]+Y[(J-1)*N1+I+1]+Y[J*N1+I]+Y[J*N1+I+1])/4*sc);
         for K:=1 to NColor do
            if ((P[L]>=MinP+DP*(K-1))and(P[L]<=MinP+DP*K)) then  begin
               SetFillStyle(1,K);
               Break;
            end;
         FloodFill (XC, YC, LightRed);
{        Str(K,S);
        OutTextXY(XC,YC,S);}
      end;
   end;
   Line(320,0,320,480);
   ReadLn; ReadLn;
   CloseGraph;
end.
