/*****************************************************************************
* .FILE  : numeric.c
* .TITLE :   ⥣ࠫ   ⮤ ᮭ (ࠡ)
* .DESCR : ᮢ ஥  ᫥ ⮤ (1994 )
*        :
*        :  믮: ७ .. (. -301)
*        :  ஢ਫ:  ..
*        :
* .NOTE  : NOT FOR RENTAL OR SALE.
*        : FEDERAL LAW PROVIDES SEVERE CIVIL & CRIMINAL PENALTIES FOR
*        : UNAUTHORIZED DUPLICATION OR DISTRIBUTION.
*        :
*        : (C) '94 by P$P
*****************************************************************************/
#include <math.h>
#include <stdio.h>
/*****************************************************************************
* .NAME   : m_Simpson
* .TITLE  :  ⥣ࠫ ⮤ ᮭ (ࠡ)
* .DESCR  :
*         :
* .PARAMS : double m_Simpson (double (*func) (double, double),
*         :                   double t_fix, double t_limit, int N);
*         :        double (*func) (double, double) - ⥣ࠫ쭠 -
*         :        double t_fix   - 䨪஢  㬥
*         :        double t_limit - 孨 । ⥣஢,
*         :                          ࠢ -t_limit
*         :        int N          - ᫮ 祪 ࠧ
* .RETURN : 祭 ᫥ ⥣ࠫ
*****************************************************************************/
double m_Simpson (double (*func) (double, double),
                  double t_fix, double t_limit, int N)
 {
   double sum1 = 0; /* Ŀ                        */
   double sum2 = 0; /*   ६ ६   */
   double sum3 = 0; /*                         */
   double sum;      /*  १        */
   double h    = (2 * t_limit) / N; /* 蠣 ⪨ */
   int i;           /* ६                 */

    sum1 = (*func) (t_fix, -t_limit) + (*func) (t_fix, +t_limit);

    for (i = 1; i <= N - 1; i++) sum2 += (*func) (t_fix, -t_limit + (i * h));
    sum2 *= 2;

    for (i = 1; i <= N; i++) sum3 += (*func) (t_fix, -t_limit + ((i-0.5) * h));
    sum3 *= 4;

    sum = sum1 + sum2 + sum3;
    sum = (h / 6) * sum;
  return sum;
 }
                      /*                       */
                      /*  ६ */
                      /* ~~~~~~~~~~~~~~~~~~~~~ */
#define PI 3.1415926536    /* ᫮                                    */
double k;                  /* ࠬ 㭪樨 -  짮⥫ */
int N_MAX;                 /* ᫮ 㧫 ⪨ ࠧ     */
double (*currFunc) (double, double); /* ࠭ 짮⥫ 㭪 */

double f1 (double x, double y);
double f2 (double x, double y);
double f3 (double x, double y);

/*****************************************************************************
* .NAME   : double F (double dummy, double t)
* .TITLE  :  ७ ⥣ࠫ (G (t)).
*         : . ⥪ ᮢ ஥.
* .DESCR  :                           /2
*         :                            
*         : ࢠ 塞 㭪  G (t + /2) * sin (t + /2) dt
*         :             t              
*         :                         -/2
*         :  G (t) =  currFunc (t, tau) dtau
*         :             
*         :            -t
* .PARAMS : double F (double dummy, double t);
*         :        double dummy - 䨪⨢  㬥,  맮 ⮩
*         :                       㭪樨   ᯮ, .. 
*         :                       㭪  㬥
*         :        double       - ⢨⥫ ன 㬥
* .RETURN : 祭 㭪樨: G (t) * sin (k * t);
*****************************************************************************/
double F (double dummy, double t)
 {
   double G;
   t = t + PI / 2; /* ᤢ 砫 न, ⮡ ।    */
                   /* 뫨 ᨬ ( 襬 砥 -  /2) */
    G = m_Simpson (currFunc, t, t, N_MAX);
  return G * sin (k * t);
 }
/*****************************************************************************
* .NAME   : main
* .TITLE  : ᭮  㭪.
* .DESCR  : 訢  짮⥫ 㭪,
*         : ࠬ k  ᫮ 㧫 ⪨ N_MAX.
*         : 뢮  ࠭ ᫥ 祭 ⥣ࠫ 
*         :  ࠢ 祭 -   /2.
*         :
* .PARAMS : void main (void);
* .RETURN :
*****************************************************************************/
void main (void)
 {
   double integral;  /* 祭 ᫥ ⥣ࠫ */
   int    selection; /*  ࠭ 㭪樨         */
   /* ᨢ 㯭 㭪権 */
   double (*functions []) (double, double) = { f1, f2, f3 };

    printf ("\n   ᫥ ⥣ࠫ ⮤ ᮭ (ࠡ)   ");
    printf ("\n   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   ");
    printf ("\n                                                   ");
    printf ("\n          I =  sin k(x + y) f (x, y) dx dy         ");
    printf ("\n                                                   ");
    printf ("\n              D                                      ");
    printf ("\n  D = { (x, y): x, y >= 0; x + y <=  }, f  C (D)");
    printf ("\n");
    printf ("\n  㭪樨 뢠:             ");
    printf ("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~             ");
    printf ("\n  1) f (x, y) = 0.5 * cos (y)               ");
    printf ("\n                              0; k != 1  ");
    printf ("\n      sin x * sin (kx) dx =>              ");
    printf ("\n                              /2; k = 1 ");
    printf ("\n                                            ");
    printf ("\n  2) f (x, y) = 0.5 - sin (y)               ");
    printf ("\n                                           ");
    printf ("\n      x * sin (kx) dx =====> ; k = 1      ");
    printf ("\n                                           ");
    printf ("\n                                            ");
    printf ("\n  3) f (x, y) = sqrt (x * x + y * y)");
    printf ("\n");
    do
     {
       printf (" 롮: ");
       scanf ("%d", &selection);
     } while (!(1 <= selection && selection <= 3));

    printf ("ࠬ k: ");
    scanf ("%lg", &k);

    do
     {
       printf ("᫮ 㧫 ⪨ N: ");
       scanf ("%d", &N_MAX);
     } while (!(N_MAX > 0));
    printf ("\n");
    printf ("\n  ⥣ࠫ ...");

    currFunc = functions [selection - 1];          /* ⥪ 㭪    */
    integral = m_Simpson (F, 0, PI / 2, N_MAX);    /* 塞 ⥣ࠫ */
    printf ("\n 祭 ⥣ࠫ ࠢ: %.12lg", integral); /* 뢮   */
    printf ("\n 稭:  = %.12lg; /2 = %.12lg", PI, PI / 2);
 }

