function [tout, yout] = eil(FunFcn, t0, tfinal, y0)
% Program, that integrate system of ordinary differential equations
% by Eiler method
t = t0;
y = y0(:);
h=0.01;
hm=2*(1/max(poly(y0)));
k1=feval(FunFcn,t,y);
tout = t;
yout = y.';
t=t0;
while t<tfinal
 t=t+h;
 k1=feval(FunFcn,t,y);
 k2=feval(FunFcn,t+h/2,y+h*k1);
 k3=feval(FunFcn,t+h/2,y+h*k2/2);
 k4=feval(FunFcn,t+h,y+h*k3);
 y=y+(k1+2*k2+2*k3+k4)*h/6;
 tout = [tout; t];
 yout = [yout; y.'];
 home,t,h
 e=0.01*max(abs(y));
 h=e/(max(abs(feval(FunFcn,t,y)))+e/hm);
end