function [tout, yout] = eil(FunFcn, t0, tfinal, y0)
% Program, that integrate system of ordinary differential equations
% by Eiler method
t = t0;
y = y0(:);
h=0.01;
hm=2*(1/max(poly(y0)));
ym=feval(FunFcn,t,y);
tout = t;
yout = y.';
t=t0;
while t<tfinal
 t=t+h;
 ym=feval(FunFcn,t,y);
 yt=y+h*ym;
 yt=feval(FunFcn,t+h,yt);
 y=y+(ym+yt)*h/2;
 tout = [tout; t];
 yout = [yout; y.'];
 home,t,h
 e=0.01*max(abs(y));
 h=e/(max(abs(feval(FunFcn,t,y)))+e/hm);
end