unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ComCtrls, Grids, Menus, Printers, Gauges;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    GroupBox3: TGroupBox;
    Edit1: TEdit;
    Button1: TButton;
    BitBtn1: TBitBtn;
    GroupBox2: TGroupBox;
    Memo2: TMemo;
    SaveDialog1: TSaveDialog;
    Image1: TImage;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    PrintSetup1: TMenuItem;
    Print1: TMenuItem;
    N2: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    StatusBar1: TStatusBar;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    PrintDialog1: TPrintDialog;
    SpeedButton3: TSpeedButton;
    PrinterSetupDialog1: TPrinterSetupDialog;
    SpeedButton4: TSpeedButton;
    GroupBox4: TGroupBox;
    StringGrid1: TStringGrid;
    StringGrid2: TStringGrid;
    Gauge1: TGauge;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox5: TGroupBox;
    Memo1: TMemo;
    GroupBox6: TGroupBox;
    Edit2: TEdit;
    Button2: TButton;
    Label10: TLabel;
    Label11: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    RadioButton3: TRadioButton;
    Button3: TButton;
    procedure FormActivate(Sender: TObject);
    procedure DrawFunction;
    procedure Button1Click(Sender: TObject);
    procedure Edit1Exit(Sender: TObject);
    Procedure CalculateSp;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Eks;
    procedure d1;
    procedure d2;
    procedure ClearAll;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  A:array[1..50,1..51] of real;
  sigma:array[1..50] of real;
  delta:array[1..50] of real; //
  h:real; // 
  y:array[1..50] of real;
  masX:array[1..50] of real;
  S,point:real; //     (  . )
  b:integer;
  pogr:real;
implementation

{$R *.DFM}
procedure TForm1.DrawFunction;
Var dx,dy:real;
    i:integer;
begin
 with form1.image1.Canvas do begin //
 Pen.Style:=psSolid;pen.Color:=clBlack;
 MoveTo(5,0);lineto(5,305); moveto(5,305);lineto(205,305);
 MoveTo(105,303);LineTo(105,307); MoveTo(205,303);LineTo(205,307);
 end;
 with form1.image1.Canvas do begin //
 pen.Style:=psDot; pen.Color:=clGreen;
 MoveTo(5,205);LineTo(205,205);
 MoveTo(5,105);LineTo(205,105);
 MoveTo(5,005);LineTo(205,005);
 MoveTo(105,303);LineTo(105,5);
 MoveTo(205,303);LineTo(205,5);
 For i:=0 to 2000 do begin
 dx:=i/1000;
 dy:=3*exp(-5*(dx)+2.5*sqr(dx));
 Form1.image1.Canvas.Pixels[round(dx*100+5),round(-dy*100+305)]:=clred;
 end;
 TextOut(7,292,'0');TextOut(195,292,'2');TextOut(7,5,'3');
image1.Picture.bitmap.savetofile('c:\temp.bmp');
 end;
 with form1.image1.Canvas do Pen.Style:=psSolid;

end;

procedure TForm1.FormActivate(Sender: TObject);
begin
StatusBar1.Panels[0].text:=datetostr(date);
StatusBar1.Panels[1].text:='   ';
DrawFunction;
StringGrid1.Cells[1,0]:='  X';
StringGrid1.Cells[2,0]:=' Y(X)';
StringGrid2.Cells[0,0]:='  X';
StringGrid2.Cells[1,0]:=' Y(X)';
StringGrid2.Cells[2,0]:=' S(X)';
StringGrid2.Cells[3,0]:='Y-S(X)';
RadioButton1.Checked:=true;
end;

procedure TForm1.Edit1Exit(Sender: TObject);
var
ed1i,n:integer;
dx,x,y:real;
begin
if StrToInt(Edit1.Text)<2 then
messagedlg('     ', mtError, [mbOk], 0)
else begin
Memo1.Text:='';
n:=strtoint(Edit1.Text)-1;
dx:=2/n;x:=-dx;
If n>7 then StringGrid1.RowCount:=n+2;
For ed1i:=0 to StringGrid1.RowCount do begin
 StringGrid1.cells[0,ed1i+1]:='';
 StringGrid1.Cells[1,Ed1i+1]:='';
 StringGrid1.Cells[2,ed1i+1]:='';
end;
For ed1i:=0 to n do begin
 x:=x+dx;
 y:=3*exp(-5*(x)+2.5*(X)*(x));
 StringGrid1.cells[0,ed1i+1]:=inttostr(ed1i);
 StringGrid1.Cells[1,Ed1i+1]:=floattostrF(x,ffNumber,4,4);
 StringGrid1.Cells[2,ed1i+1]:=floattostrF(y,ffNumber,4,4);
end;
image1.picture.Bitmap.SaveToFile('c:\temp.bmp');
end; // if'a
end;


////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                                //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
procedure Tform1.Eks;
var
 n:integer;
 m,i,j:integer;
 sum,p,l:real;
 z:integer;
 otvet:ANSIString;
 x,buf:real;
begin
 Memo1.Text:='';
 n:=strtoint(Edit1.Text)-1;
 h:=2/n;

//      
 For i:=1 to n-1 do begin
  For j:=1 to n-1 do begin
   if j=i then A[i,j]:=4*h;
   if j=(i-1) then A[i,j]:=h;
   If j=(i+1) then A[i,j]:=h;
   if ((j<>i) and (j<>(i-1)) and (j<>(i+1))) then A[i,j]:=0;
  end;
 end;

//   ,x
x:=-h;
For i:=0 to n do begin
 x:=x+h;
 masX[i+1]:=x;
 y[i+1]:=3*exp(-5*(x)+2.5*(X)*(x));
end;

//   
for i:=1 to n do delta[i]:=(y[i+1]-y[i])/h;

//  - 
For i:=1 to n-1 do A[i,n]:=(delta[i+1]-delta[i]);

// -  . -  . 
i:=2;
for z:=1 to (n-1)-1 do begin
 for i:=z+1 to n-1 do begin
 l:=A[i,z]/A[z,z];
  for j:=z to (n+1)-1 do begin
  A[i,j]:=A[i,j]-l*A[z,j];
  end;
 end;
end;

//  
For i:=1 to n+1 do sigma[i]:=0;
For i:=n-1 downto 1 do begin
 sum:=A[i,n+1-1];
 For j:=i to n do begin
  sum:=sum-A[i,j]*sigma[j]
 end;
 sigma[i]:=sum/A[i,i];
end;

//     
 For i:=n downto 1 do sigma[i+1]:=sigma[i];
 sigma[1]:=0; sigma[n+1]:=0;

//   
For i:=1 to n+1 do begin otvet:=inttostr(i-1)+':'+' '+ floattostrF(sigma[i], ffNumber,4,4);
Memo1.lines.add(otvet);end;

// 
for i:=0 to 200 do begin
 point:=i*0.01;
 calculateSp;
 Gauge1.Progress:=(round(i div 2));
end;
end;

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                           //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
procedure TForm1.d1;
var
 k,n:integer;
 m,i,j:integer;
 sum,p,l:real;
 z:integer;
 otvet:ANSIString;
 xx,x,buf:real;
begin
 Memo1.Text:='';
 n:=strtoint(Edit1.Text)-1;
 h:=2/n;

//  - 
A[1,1]:=2*h; A[1,2]:=h;
for i:=2 to n do begin
 for j:=1 to n+1 do begin
  if j=i then A[i,j]:=4*h;
  if j=i-1 then A[i,j]:=h;
  if j=i+1 then A[i,j]:=h;
  if ((i<>j) and (j<>i-1) and (j<>i+1)) then A[i,j]:=0;
 end;
end;
A[n+1,n]:=h; A[n+1,n+1]:=2*h;

//   ,x
x:=-h;
For i:=0 to n do begin
 x:=x+h;
 masX[i+1]:=x;
 y[i+1]:=3*exp(-5*(x)+2.5*(X)*(x));
end;

//   
for i:=1 to n do delta[i]:=(y[i+1]-y[i])/h;

//  - 
For i:=2 to n do A[i,n+2]:=(delta[i]-delta[i-1]);
A[1,n+2]:=8.6522; A[n+1,n+2]:=8.6522;

//  -   
i:=2;
for z:=1 to n+1 do begin
 for i:=z+1 to n+1 do begin
 l:=A[i,z]/A[z,z];
  for j:=z to n+2 do begin
  A[i,j]:=A[i,j]-l*A[z,j];
  end;
 end;
end;

//  
For i:=1 to n+1 do sigma[i]:=0;
For i:=n+1 downto 1 do begin
 sum:=A[i,n+2];
 For j:=i to n+1 do begin
  sum:=sum-A[i,j]*sigma[j]
 end;
 sigma[i]:=sum/A[i,i];
end;

//   
For i:=1 to n+1 do begin otvet:=inttostr(i)+':'+' '+ floattostrF(sigma[i], ffNumber,4,4);
Memo1.lines.add(otvet);end;

// 
for i:=0 to 200 do begin
 point:=i*0.01;
 calculateSp;
 Gauge1.Progress:=(round(i div 2));
end;
end;

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                                           //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////
procedure TForm1.d2;
var
 k,n:integer;
 m,i,j:integer;
 sum,p,l:real;
 z:integer;
 otvet:ANSIString;
 xx,x,buf:real;
begin

 Memo1.Text:='';
 n:=strtoint(Edit1.Text)-1;
 h:=2/n;

//  - 
A[1,1]:=6; A[1,2]:=0;
for i:=2 to n do begin
 for j:=1 to n+1 do begin
  if j=i then A[i,j]:=4*h;
  if j=i-1 then A[i,j]:=h;
  if j=i+1 then A[i,j]:=h;
  if ((i<>j) and (j<>i-1) and (j<>i+1)) then A[i,j]:=0;
 end;
end;
A[n+1,n]:=0; A[n+1,n+1]:=6;

//   ,x
x:=-h;
For i:=0 to n do begin
 x:=x+h;
 masX[i+1]:=x;
 y[i+1]:=3*exp(-5*(x)+2.5*(X)*(x));
end;

//   
for i:=1 to n do delta[i]:=(y[i+1]-y[i])/h;

//  - 
For i:=2 to n do A[i,n+2]:=(delta[i]-delta[i-1]);
A[1,n+2]:=90; A[n+1,n+2]:=90;

i:=2;
for z:=1 to n+1 do begin
 for i:=z+1 to n+1 do begin
 l:=A[i,z]/A[z,z];
  for j:=z to n+2 do begin
  A[i,j]:=A[i,j]-l*A[z,j];
  end;
 end;
end;

//  
For i:=1 to n+1 do sigma[i]:=0;

For i:=n+1 downto 1 do begin
 sum:=A[i,n+2];
 For j:=i to n+1 do begin
  sum:=sum-A[i,j]*sigma[j]
 end;
 sigma[i]:=sum/A[i,i];
end;

//   
For i:=1 to n+1 do begin otvet:=inttostr(i)+':'+' '+ floattostrF(sigma[i], ffNumber,4,4);
Memo1.lines.add(otvet);end;

// 
for i:=0 to 200 do begin
 point:=i*0.01;
 calculateSp;
 Gauge1.Progress:=(round(i div 2));
end;
end;

////////////////////////////////////////////////////////////////////////////////
procedure TForm1.Button1Click(Sender: TObject);
Var
 m,i,j:integer;
 sum,p,l:real;
 z:integer;
 otvet:ANSIString;
 n:integer; //  
 x,buf:real;
begin
StatusBar1.Panels[1].text:=' ...';
ClearAll;
If RadioButton1.Checked=true then Eks; //. . .
If RadioButton2.Checked=true then d1;  //. .  . .
If RadioButton3.Checked=true then d2;  //. .  . .
end;

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//                    ,                    //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

Procedure TForm1.CalculateSp;
Var
n,number:integer;
x,dx:real;
temp:real;
w,wsh:real;
begin
n:=strtoint(Edit1.Text)-1;
dx:=2/n;x:=0;number:=0;

// ,    
While x<=point do begin
x:=x+dx;
number:=number+1;
end;
If x=0 then number:=1;
if point=0 then begin b:=1; pogr:=0; end;
memo2.text:=''+' '+floattostr(number);

//        =point
w:=(point-masX[number])/h;
memo2.lines.add(floattostr(w));
wsh:=1-w;
memo2.lines.add(floattostr(wsh));
S:=w*y[number+1]+wsh*y[number]+h*h*((w*w*w-w)*sigma[number+1]+(wsh*wsh*wsh-wsh)*sigma[number]);
Memo2.lines.add(floattostr(S));

temp:=3*exp(-5*(point)+2.5*sqr(point));
// x
StringGrid2.cells[0,b]:=FloattostrF(point,ffNumber,4,3);
// y
StringGrid2.cells[1,b]:=FloattostrF(temp,ffNumber,4,4);
// s
StringGrid2.Cells[2,b]:=FloattostrF(S,ffNumber,4,4);
// y-s
StringGrid2.Cells[3,b]:=FloattostrF(temp-S,ffNumber,4,4);
b:=b+1;

if pogr<abs(temp-s) then pogr:=abs(temp-s);
label2.Caption:=FloattostrF(pogr, ffNumber, 4,4);
label6.Caption:='='+FloattostrF(pogr/3, ffNumber, 4,4);

If RadioButton1.Checked=true then with Image1.Canvas do pen.Color:=clblue;
If RadioButton2.Checked=True then with Image1.Canvas do pen.Color:=clyellow;
If RadioButton3.Checked=True then with Image1.Canvas do pen.Color:=clPurple;

if point=0 then With image1.Canvas do moveto(5,5);
With image1.canvas do lineto(round(point*100+5),round(-s*100+305));
if point>1.99 then StatusBar1.Panels[1].text:='   ';
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
savedialog1.execute;
If savedialog1.filename<>'' then
image1.Picture.Bitmap.SaveToFile(savedialog1.filename);
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
With form1.image1 do Canvas.Fillrect(rect(0,0,clientwidth,clientheight));
DrawFunction;
end;

procedure TForm1.Print1Click(Sender: TObject);
begin
 image1.Picture.LoadFromFile('c:\temp.bmp');
with Printer do
 begin
  BeginDoc;	{ start printing }
  canvas.Draw(0,0, image1.Picture.Bitmap);
  EndDoc;	{ finish printing }
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
try point:=strtofloat(edit2.text);
except on EConverterror do  begin MessageDlg('  ', mtError, [mbOk], 0);
point:=0;end;
end;
calculateSp;
Label14.Caption:=FloattostrF(S, ffNumber, 4,4);
Label15.caption:=FloattostrF(abs(3*exp(-5*(point)+2.5*sqr(point))-S) ,ffNumber,4,4);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
form1.close;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
printerSetupdialog1.Execute;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
f:textfile;
k,l:integer;

begin
SaveDialog1.Execute;
IF savedialog1.filename<>'' then begin
assignfile(f,SaveDialog1.Filename);
rewrite(f);
WriteLn(f,'   '+datetostr(date)+' '+timetostr(time));
WriteLn(f,'   n='+edit1.Text);
WriteLn(f,'  h='+FloatToStrF(h, ffNumber, 4, 4));
If RadioButton1.Checked=true then WriteLn(f,'  ');
If RadioButton2.Checked=true then WriteLn(f,'    ');
If RadioButton3.Checked=true then WriteLn(f,'    ');
//
writeLn(f,':');
for k:=1 to strtoint(Edit1.Text) do WriteLn(f, inttostr(k)+':'+FloatToStrF(sigma[k], ffNumber, 4,4)+' ');
WriteLn(f,':');
WriteLn(f,'  X  ','   Y(X) ','  S(X) ',' Y-S(X)');
For k:=1 to 202 do
WriteLn(f,(StringGrid2.Cells[0,k]),' ',(StringGrid2.Cells[1,k]),' ',(StringGrid2.Cells[2,k]),' ',(StringGrid2.Cells[3,k]));
WriteLn(f,'max|F(x)-S(x)|=',label2.Caption);
WriteLn(f,'max|F(x)-S(x)|/max|F(x)|=',label6.Caption);
closefile(f);
end;
end;

Procedure TForm1.ClearAll;
 var c,cc:integer;
begin
For c:=1 to 50 do begin
 For cc:=1 to 50 do begin
  A[c,cc]:=0;
 end;
end;
For c:=1 to 50 do sigma[c]:=0;
For c:=1 to 50 do delta[c]:=0;
For c:=1 to 50 do y[c]:=0;
For c:=1 to 50 do masX[c]:=0;
S:=0; point:=0;
b:=0; pogr:=0;
h:=0;
end;

end.