//Runge-Kutt template
//version 1.00
//By Dmitry Kornilov



#ifndef _MATRIX_H
#include "matrix.h"
#endif



template <class T> class CRunge4 {
public:
	CRunge4(){};
	CRunge4(TMatrix<T>,T,T);
	virtual TMatrix<T> f(T,TMatrix<T>)=0;
	TMatrix<T> Next();
private:
TMatrix<T> prev;
T h;
T xprev;
};

template <class T> CRunge4<T>::CRunge4(TMatrix<T> m,T f,T x)
{
h=f;
prev=m;
xprev=x;
}


template <class T> TMatrix<T> CRunge4<T>::Next()
{
TMatrix<T>& m= *new TMatrix<T>(prev.GetRows(),prev.GetCols());
TMatrix<T> k1,k2,k3,k4;

k1=f(xprev,prev)*h;

k2=f(xprev+h/2,prev+k1*0.5)*h;
k3=f(xprev+h/2,prev+k2*0.5)*h;
k4=f(xprev+h,prev+k3)*h;
m=prev+((T)1/6)*(k1+2.0*k2+2.0*k3+k4);

prev=m;
xprev+=h;
return m;
}