// 
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <time.h>
#include "matrix.h"
#include "runge.h"
#include "random.h"

//
const double Da=0.1;

const double Dn=0.03;
const double K1=2.5;
const double K2=1.9;
const double l=1.2;
const double Kp=13;
const double S1=0.5;
const double S2=27;
const double S3=3;
const double dh=0.001;

template<class T> class CMyRunge:public CRunge4<T>{
public:
	CMyRunge(TMatrix<T> t,T h, T x):CRunge4<T>(t,h,x){};
	TMatrix<T> f(T,TMatrix<T>);
static	T F1(T);
static	T F2(T);
static	T F3(T);
protected:
	T k1,k2;
};





template <class T> TMatrix<T> CMyRunge<T>::f(T h,TMatrix<T> m)
{
	double d=10;
k1=sqrt(Da*l/3.14159);
k2=sqrt(Dn*l/3.14159);


TMatrix<T>* t=new  TMatrix<T>(3,1);
t->Element(1,1,-l*m.Element(1,1)+k1*gauss(0,d));
t->Element(2,1,-l*m.Element(2,1)+k2*gauss(0,d));
t->Element(3,1,m.Element(2,1)+F2(F1(Kp*(m.Element(1,1)-m.Element(3,1)))));

return *t;
}



template <class T> T CMyRunge<T>::F1(T x)
{
if(fabs(x)>=S1)
return (K2*x+x/fabs(x)*S1*(K1-K2)); else
return(K1*x);


return 0;
}


template <class T> T CMyRunge<T>::F2(T x)
{
if(x<=-S2)
return (-S2);
if(fabs(x)<S2)
return(x);
if(x>=S2)
return (S2);
return 0;
}

template <class T> T CMyRunge<T>::F3(T x)
{
if(x<=-S3)
return (-S3);
if(fabs(x)<S3)
return(x);
if(x>=S3)
return (S3);
return 0;
}




main()
{
int i;

TMatrix<double> m(3,1);
m.Element(1,1,0);
m.Element(2,1,0);
m.Element(3,1,0);
CMyRunge<double> r(m,dh,0);

filebuf f;
f.open("a.dat",ios::out );
ostream o(&f);

double t=0;
double dt=2.0/100;

for(i=1;i<=200;i++){
	t+=dt;
m=r.Next();
o<<m.Element(1,1)<<"\t"<<m.Element(2,1)<<
"\t"<<CMyRunge<double>::F3(m.Element(3,1))<<"\t"<<t<<endl;
//cout<<m.Element(1,1)<<"\t"<<m.Element(2,1)<<
//"\t"<<CMyRunge<double>::F3(m.Element(3,1))<<endl;
}
cin>>i;
return 0;
}


