//Matrix Template Library, version 1.00
//(c) by Dmitry Kornilov, 1997
//Designed for Microsoft Visual C++ and Borland C++

#ifndef _IOSTREAM_H
#include <iostream.h>
#endif


#ifndef _MATRIX_H
#define _MATRIX_H
#endif


#define INDEX(i,j,col) (i-1)*col+j-1


template <class T> class TMatrix
{public:
 TMatrix(int ,int );
 TMatrix(){col=row=0;buffer=NULL;};
 TMatrix(TMatrix<T>&);
 ~TMatrix();
void Element(int,int,T);
T Element(int,int);
TMatrix<T> Minor(int, int);
TMatrix<T> Invert();
TMatrix<T> Transpose();
T Determinant();
int GetRows(){return row;}
int GetCols(){return col;}
friend TMatrix operator+(TMatrix<T>&,TMatrix<T>&);
friend TMatrix operator+(TMatrix<T>&,T);
friend TMatrix operator-(TMatrix<T>&,TMatrix<T>&);
friend TMatrix operator*(T,TMatrix<T>&);
friend TMatrix operator*(TMatrix<T>&,T);
friend TMatrix operator*(const TMatrix<T>& ,const TMatrix<T>& );
friend ostream& operator<< (ostream&, const TMatrix<T>&);
void operator=(TMatrix&);

 protected:
T *buffer;
int row,col;
};


class TMatrixError 
{public:
int Error;
char* Message;
TMatrixError(int n) {Error=n;  };
char* GetString();
};


char* TMatrixError::GetString()
{
if(Error==5) Message="Index Error";
return Message;
} 



template <class T> TMatrix<T>::TMatrix(int rows,int cols)
{
row=rows;
col=cols;
buffer=new T[row*col];
}


template <class T> TMatrix<T>::~TMatrix()
{
delete [] buffer;

}

template <class T> TMatrix<T>::TMatrix(TMatrix<T> &m)
{
row=m.row;
col=m.col;
buffer=new T [row*col];
for(int i=1;i<=row;i++)
for(int j=1;j<=col;j++)
buffer[(i-1)*col+j-1]=m.buffer[(i-1)*m.col+j-1];
}

template <class T>void TMatrix<T>::Element(int i,int j, T f)
{
buffer[(i-1)*col+j-1]=f;

}

template <class T>T TMatrix<T>::Element(int i,int j)
{
if((i>row)||(j>col)) throw(TMatrixError(5));
return buffer[(i-1)*col+j-1];
}

template <class T> TMatrix<T>  operator+(TMatrix<T>& m1, TMatrix<T>& m2)
{
TMatrix<T>& m= *new TMatrix<T>(m1.row,m1.col);
for(int i=1;i<=m1.row;i++)
for(int j=1;j<=m1.col;j++)
m.buffer[(i-1)*m1.col+j-1]=m1.buffer[(i-1)*m1.col+j-1]+
m2.buffer[(i-1)*m1.col+j-1];
//m.Element(i,j,m1.Element(i,j)+m2.Element(i,j));
return m;
}



template <class T> TMatrix<T>  operator+(TMatrix<T>& m1, T f)
{
TMatrix<T>& m= *new TMatrix<T>(m1.row,m1.col);
for(int i=1;i<=m1.row;i++)
for(int j=1;j<=m1.col;j++)
m.buffer[(i-1)*m1.col+j-1]=m1.buffer[(i-1)*m1.col+j-1]+f;
//m.Element(i,j,m1.Element(i,j)+m2.Element(i,j));
return m;
}








template <class T> TMatrix<T>  operator-(TMatrix<T>& m1, TMatrix<T>& m2)
{
TMatrix<T> *m;
m=new TMatrix<T>(m1.row,m1.col);
for(int i=1;i<=m1.row;i++)
for(int j=1;j<=m1.col;j++)
m->buffer[(i-1)*m1.col+j-1]=m1.buffer[(i-1)*m1.col+j-1]-
m2.buffer[(i-1)*m1.col+j-1];
return *m;
}

template <class T> TMatrix<T>  operator*(T f, TMatrix<T>& m1)
{
TMatrix<T> *m;
m=new TMatrix<T>(m1.row,m1.col);
for(int i=1;i<=m1.row;i++)
for(int j=1;j<=m1.col;j++)
m->buffer[(i-1)*m1.col+j-1]=m1.buffer[(i-1)*m1.col+j-1]*f;
return *m;
}


template <class T> TMatrix<T>  operator*(TMatrix<T>& m1, T f)
{
TMatrix<T>& m =*new TMatrix<T>(m1.row,m1.col);
for(int i=1;i<=m1.row;i++)
for(int j=1;j<=m1.col;j++)
m.buffer[(i-1)*m1.col+j-1]=m1.buffer[(i-1)*m1.col+j-1]*f;
return m;
}




template <class T> void TMatrix<T>::operator=(TMatrix<T>& m)
{
row=m.row;
col=m.col;
if(!buffer) buffer=new T [row*col];
for(int i=1;i<=row;i++)
for(int j=1;j<=col;j++)
buffer[(i-1)*col+j-1]=m.Element(i,j);
}

template<class T>  TMatrix<T>   operator*(const TMatrix<T>& m1,const TMatrix<T>& m2)
{
int i,j,k;
T f3,f2,f1;
TMatrix<T>* m =new TMatrix<T>(m1.row,m2.col);
for(i=1;i<=m1.row;i++)
for(j=1;j<=m2.col;j++)
{
f3=0;
for(k=1;k<=m1.col;k++){
f1=m1.buffer[INDEX(i,k,m1.col)];
f2=m2.buffer[INDEX(k,j,m1.col)];
f3=f3+f1*f2;}
m->Element(i,j,f3);
}

return  *m;
}


template <class T> ostream& operator<< (ostream& o, const TMatrix<T>& m)
{
for(int i=1;i<=m.row;i++){
for(int j=1;j<=m.col;j++)
o<<m.buffer[INDEX(i,j,m.col)]<<"\t";
o<<endl;
}
o<<endl;
return o;
}


template <class T> TMatrix<T> TMatrix<T>::Minor(int i, int j)
{
TMatrix<T> *m=new TMatrix<T>(row-1,col-1);
int count=0;
for (int i1=1;i1<=row;i1++)
for (int j1=1;j1<=col;j1++)
if ((i1!=i) && (j1!=j))
{
m->buffer[count]=buffer[INDEX(i1,j1,col)];

count++;
}

return *m;
}


template <class T> T TMatrix<T>::Determinant()
{
if( col==2) {
return buffer[INDEX(1,1,2)]*buffer[INDEX(2,2,2)]-
buffer[INDEX(1,2,2)]*buffer[INDEX(2,1,2)];}

T f=0;
TMatrix<T> p;
for(int i=1;i<=col;i++){
p=Minor(i,1);
f=f+buffer[INDEX(i,1,col)]*p.Determinant()*sign(i+1);
}
return f;
}
int sign(int i)
{
	
if( (i % 2)==0) return 1; else
return -1;

}



template <class T> TMatrix<T> TMatrix<T>::Invert()
{
TMatrix<T> *m=new TMatrix<T>(row,col);
T f=Determinant();
for (int i=1;i<=row;i++)
for (int j=1;j<=col;j++)
m->buffer[INDEX(i,j,col)]=sign(i+j)*(Minor(j,i).Determinant())/f;
return *m;
}



template <class T> TMatrix<T> TMatrix<T>::Transpose()
{
TMatrix<T> *m=new TMatrix<T>(col,row);

for (int i=1;i<=row;i++)
for (int j=1;j<=col;j++)
m->buffer[INDEX(j,i,row)]=buffer[INDEX(i,j,col)];
return *m;
}

