//     
//  . 07-403
// . .
//  




// 
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <time.h>
#include "matrix.h"
#include "runge.h"
#include "random.h"



//
const double Da=0.1;
const double Dn=0.03;
const double K1=2.5;
const double K2=1.9;
const double l=1.2;
const double Kp=13;
const double S1=0.5;
const double S2=27;
const double S3=3;
const double dh=0.01;


//    
template<class T> class CMyRunge:public CRunge4<T>{
public:
	CMyRunge(TMatrix<T> t,T h, T x):CRunge4<T>(t,h,x){};
	TMatrix<T> f(T,TMatrix<T>);
};



//   
template<class T> class CKovariation:public CRunge4<T>{
public:
	CKovariation(TMatrix<T> t,T h, T x):CRunge4<T>(t,h,x){};
	TMatrix<T> f(T,TMatrix<T>);
};




// 
TMatrix<double> A(3,3);
TMatrix<double> B(3,1);

// 
TMatrix<double> X(3,1);

// 
TMatrix<double> K(3,3);

// 
TMatrix<double> s(3,1);

// .
double K11,K21,K31;




//  x
double Sign(double x)
{
if(x<0) return -1; else return 1;
}


// 
double erf(double x)
{
	double x1=fabs(x);
const double p=0.3275911;
const double a1=0.254829592;
const double a2=-0.284496736;
const double a3=1.421413741;
const double a4=-1.453152027;
const double a5=1.061405429;
double t=1/(1+p*x1);
return Sign(x)*(1-(a1*t+a2*pow(t,2)+a3*pow(t,3)+a4*pow(t,4)+a5*pow(t,5))*exp(-x*x));
}

// 
double KGauss(double x,double m,double D)
{
return 1/sqrt(2*3.14159*D)*exp(-1/2*(x-m)*(x-m)/D);
}

//


//  p(x)
double J0(double Low, double Up, double m, double D, int Inf)
{
	switch( Inf) {
	case -1:return (1+erf((Up-m)/sqrt(2*D)))/2;
	case 0: return (erf((Up-m)/sqrt(2*D))-erf((Low-m)/sqrt(2*D)) )/2;
	case +1:return (1-erf((Low-m)/sqrt(2*D)))/2;
	}
	return 0;


}


//  x*p(x)
double J1(double Low, double Up, double m, double D, int Inf)
{
switch(Inf){
case -1:return (-D*KGauss(Up,m,D)+m*J0(0,Up,m,D,Inf));
case 0: return(-D*(KGauss(Up,m,D)-KGauss(Low,m,D))+m*J0(Low,Up,m,D,Inf) );
case 1: return(D*KGauss(Low,m,D)+m*J0(Low,0,m,D,Inf));



}

return 0;


}


//  x*x*p(x)
double J2(double Low, double Up, double m, double D, int Inf)
{
	
switch(Inf){
case -1:return (-D*(Up*KGauss(Up,m,D)-J0(0,Up,m,D,Inf))+m*J1(0,Up,m,D,Inf));
case 0: {
	double d;
	d=-D*(Up*KGauss(Up,m,D)-Low*KGauss(Low,m,D)-
		J0(Low,Up,m,D,Inf))+m*J1(Low,Up,m,D,Inf);
	return d;}
case 1: return(-D*(-Low*KGauss(Low,m,D)-J0(Low,0,m,D,Inf))+m*J1(Low,0,m,D,Inf));



}

return 0;


}




//. 

//  
void Linear1(double m, double D, double& K0,double& K1)
{
const double s=0.5;
const double k1=2.5;
const double k2=1.9;
double l1=s*(k2-k1);
double l2=-l1;

K0=k2*J1(0,-s,m,D,-1)+l1*J0(0,-s,m,D,-1)+
k1*J1(-s,s,m,D,0)+k2*J1(s,0,m,D,1)+l2*J0(s,0,m,D,1);


K1=(k2*J2(0,-s,m,D,-1)+l1*J1(0,-s,m,D,-1)+k1*J1(-s,s,m,D,0)+
k2*J2(s,0,m,D,1)+l2*J1(s,0,m,D,1)-m*K0)/D;
}


//  
void Linear2(double m, double D, double& K0,double& K1)
{
const double s=27;

K0=-s*J0(0,-s,m,D,-1)+J1(-s,s,m,D,0)+s*J0(s,0,m,D,1);
K1=(-s*J1(0,-s,m,D,-1)+J2(-s,s,m,D,0)+s*J1(s,0,m,D,1)+
s*m*J0(0,-s,m,D,-1)-m*J1(-s,s,m,D,0)-s*m*J0(s,0,m,D,1))/D;


}


//  
void Linear3(double m, double D, double& K0,double& K1)
{
const double s=3;

K0=-s*J0(0,-s,m,D,-1)+J1(-s,s,m,D,0)+s*J0(s,0,m,D,1);
K1=(-s*J1(0,-s,m,D,-1)+J2(-s,s,m,D,0)+s*J1(s,0,m,D,1)+
s*m*J0(0,-s,m,D,-1)-m*J1(-s,s,m,D,0)-s*m*J0(s,0,m,D,1))/D;


}

//   
//
//:      
double Dx(double k1,double k2)
{
double d1,d2;
d1=1/(2*3.14159)*Kp*Kp*K.Element(1,1)*l/(l+Kp*k1*k2);
d2=1/(2*3.14159)*Kp*Kp*K.Element(2,2)/(k1*k2-l)/k1/k2;
return (d1+d2);
}

//
double Dy(double k1,double k2)
{
double d1,d2;
d1=1/(2*3.14159)*k1*k1*Kp*Kp*K.Element(1,1)*l/(l+Kp*k1*k2);
d2=1/(3.14159)*K1*Kp*K.Element(2,2)/(l-k1*k2*Kp)/k1/k2;
return (d1+d2);
}








//   



template <class T> TMatrix<T> CMyRunge<T>::f(T h,TMatrix<T> m)
{
	double d=1;


TMatrix<T>* t=new  TMatrix<T>;


s.Element(1,1,B.Element(1,1)*gauss(0,d));
s.Element(2,1,B.Element(2,1)*gauss(0,d));
s.Element(3,1,B.Element(3,1));

*t=A*m+s;

return *t;
}



//   
template <class T> TMatrix<T> CKovariation<T>::f(T h,TMatrix<T> m)
{
TMatrix<T>* t=new  TMatrix<T>(3,3);
*t=A*m+m*A.Transpose()+B*B.Transpose();
return *t;
}








//
main()
{

//  A
for(int i=1; i<=3;i++)
for(int j=1; j<=3;j++)
A.Element(i,j,0);

A.Element(1,1,-l);
A.Element(2,2,-l);
A.Element(3,2,1);


	
	
//  B
B.Element(1,1,sqrt(Da*l/3.14159));
B.Element(2,1,sqrt(Dn*l/3.14159));
B.Element(3,1,0);

//  
for(i=1; i<=3;i++)
for(int j=1; j<=3;j++)
if(i!=j)K.Element(i,j,0);

K.Element(1,1,Da);
K.Element(2,2,Dn);
K.Element(3,3,(Da*Kp*Kp+Dn)*10);


//   X
for(i=1; i<=3;i++)
X.Element(i,1,0);


//    
CMyRunge<double> Vector(X,dh,0);


//   
CKovariation<double> Kov(K,dh,0);




//
double k10,k11,k20,k21;
Linear1(0,Da*Kp*Kp,k10,k11);
Linear2(0,Da*Kp*Kp,k20,k21);

double d1=Dx(k11,k21);
double d2=Dy(k11,k21);
Linear1(0,d1,k10,k11);
Linear2(0,d2,k20,k21);
K11=k11;
K21=k21;
Linear3(0,d2+Dn,k10,k11);
K31=k11;
A.Element(3,1,K11*K21*Kp);
A.Element(3,3,-K11*K21*Kp);

int first=1;


filebuf f;
f.open("x.dat",ios::out );
ostream o(&f);

filebuf f1;
f1.open("k.dat",ios::out );
ostream o1(&f1);

double timec=0;
double dt=2.0/100;
// 
for(i=1;i<=200;i++)
{
	timec+=dt;
	//  A
if (!first){
d1=Dx(K11,K21);
d2=Dy(K11,K21);
Linear1(0,d1,k10,K11);
Linear2(0,d2,k20,K21);
Linear3(0,K.Element(3,3),k10,K31);

A.Element(3,1,K11*K21*Kp);
A.Element(3,3,-K11*K21*Kp);
first=0;
};

X=Vector.Next();
K=Kov.Next();

o<<X.Element(1,1)<<"\t"<<X.Element(2,1)<<"\t"<<
K31*X.Element(3,1)<<"\t"<<timec<<endl;

o1<<K.Element(1,1)<<"\t"<<K.Element(2,2)<<"\t"<<
K31*K31*K.Element(3,3)<<"\t"<<timec<<endl;



}





cout<<K;



cin>>i;



return 0;
}


