#ifndef __EVALDEFS_H
#define __EVALDEFS_H

#define TYPE		double		/* Type of numbers to work with */
#define VARLEN		8		/* Max length of variable names */
#define TOKLEN		30		/* Max token length */
#define MAXARG	        4	        /* Max number of arguments */

#define NAME		1		/* Name */
#define DELIM		2		/* Delimiter */
#define NUMER		3		/* Number */

typedef struct
{
   char name[VARLEN + 1];		/* Variable name */
   TYPE value;				/* Variable value */
} VARIABLE;

typedef struct
{
   char* name;				/* Function name */
   int	 args;				/* Number of arguments to expect */
   TYPE  (*func)();			/* Pointer to function */
} FUNCTION;

/* The following macros are ASCII dependant */
#define isspace(c)  ((c==' ')||(c=='\t'))
#define isnumer(c)  (((c>='0')&&(c<='9'))||(c=='.'))
#define isalpha(c)  (((c>='a')&&(c<='z'))||((c>='0')&&(c<='9'))||(c=='_'))
#define isdelim(c)  ((c=='+')||(c=='-')||(c=='*')||(c=='/')||(c=='%')\
		    ||(c=='^')||(c=='(')||(c==')')||(c==','))

/* Codes returned from the evaluator */
#define ev_OK		0	 /* Successful evaluation */
#define ev_SYNTAX	1	 /* Syntax error */
#define ev_UNBALAN	2	 /* Unbalanced parenthesis */
#define ev_DIVZERO	3	 /* Attempted division by zero */
#define ev_UNKNOWN	4	 /* Reference to unknown variable */
#define ev_BADFUNC	5	 /* Unrecognised function */
#define ev_NUMARGS	6	 /* Wrong number of arguments to funtion */
#define ev_NOARG	7	 /* Missing an argument to a function */
#define ev_MATH		8
#define ev_EMPTY	9	 /* Empty expression */

#endif