unit Edit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TEditForm = class(TForm)
    MainMenu1: TMainMenu;
    OpenItem: TMenuItem;
    OpenFile: TMenuItem;
    SaveAs: TMenuItem;
    CloseEdit: TMenuItem;
    N2: TMenuItem;
    CloseItem: TMenuItem;
    Edit: TMenuItem;
    CopyEdit: TMenuItem;
    Paste: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StatusBar: TStatusBar;
    Memo: TMemo;
    ToolBar: TPanel;
    Bevel: TBevel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    N1: TMenuItem;
    Timer1: TTimer;
    N3: TMenuItem;
    N4: TMenuItem;
    procedure CloseItemClick(Sender: TObject);
    procedure OpenFileClick(Sender: TObject);
    procedure CloseEditClick(Sender: TObject);
    procedure SaveAsClick(Sender: TObject);
    procedure OpenBtnClick(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
    procedure CopyEditClick(Sender: TObject);
    procedure PasteClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure N4Click(Sender: TObject);
   private
    { Private declarations }
  procedure EnableCommands(Enable:Boolean);
  public
    { Public declarations }
  end;

var
  EditForm: TEditForm;
implementation

{$R *.DFM}
{  }
procedure TEditForm.CloseItemClick(Sender: TObject);
begin
Close;
end;
procedure TEditForm.EnableCommands(Enable:Boolean);
begin
CopyEdit.Enabled:=Enable;
Paste.Enabled:=Enable;
CloseEdit.Enabled:=Enable;
SaveAs.Enabled:=Enable;
OpenBtn.Enabled:=Enable;
SaveBtn.Enabled:=Enable;
end;
{ }
procedure TEditForm.OpenFileClick(Sender: TObject);
var NameFile:TFileName;
begin
 OpenDialog1.Filter:='  (*.TXT)| *.TXT|  (*.*)| *.*';
 if OpenDialog1.Execute then
 begin
 NameFile:=OpenDialog1.Filename;
 Memo.Lines.LoadfromFile(OpenDialog1.FileName);
 StatusBar.Panels[1].Text:=OpenDialog1.Filename;
 EnableCommands(True);
 end;
 end;
 {  }
procedure TEditForm.SaveAsClick(Sender: TObject);
begin
 Memo.Lines.SaveToFile(OpenDialog1.FileName);
end;

procedure TEditForm.OpenBtnClick(Sender: TObject);
var NameFile:TFileName;
begin
 OpenBtn.Down:=False;
 OpenDialog1.Filter:='  (*.TXT)| *.TXT|  (*.*)| *.*';
if OpenDialog1.Execute then
begin
 Memo.Lines.LoadfromFile(OpenDialog1.FileName);
 StatusBar.Panels[1].Text:=OpenDialog1.Filename;
 EnableCommands(True);
 end;
 end;
procedure TEditForm.SaveBtnClick(Sender: TObject);
begin
 SaveBtn.Down:=True;
 Memo.Lines.SaveToFile(OpenDialog1.FileName);
end;

procedure TEditForm.CopyEditClick(Sender: TObject);
begin
 Memo.CopyToClipboard;
end;

procedure TEditForm.PasteClick(Sender: TObject);
begin
 Memo.PasteFromClipboard;
end;
procedure TEditForm.CloseEditClick(Sender: TObject);
begin
 StatusBar.Panels[1].Text:='';
 Memo.Lines.clear;
 EnableCommands(True);
end;

procedure TEditForm.N1Click(Sender: TObject);
begin
MessageDlg('Good program made in KSP 31 "Freeware"',mtCustom,[mbOk],0);
end;

procedure TEditForm.Timer1Timer(Sender: TObject);
begin
n3.Caption:=timetostr(now);
end;
procedure TEditForm.N4Click(Sender: TObject);
begin
N4.Create(Self);
end;

end.
