#ifndef _VESA_H
#define _VESA_H

#include "color.h"

// 16 梥⮢
#define	VESA_800x600x4		0x102
#define	VESA_1024x768x4		0x104
#define	VESA_1280x1024x4	0x106
// 256 梥⮢
#define	VESA_640x400x8		0x100
#define	VESA_640x480x8		0x101
#define	VESA_800x600x8		0x103
#define	VESA_1024x768x8		0x105
#define	VESA_1280x1024x8	0x107
// HiColor
#define	VESA_320x200x15		0x10D
#define	VESA_640x480x15		0x110
#define	VESA_800x600x15		0x113
#define	VESA_1024x768x15	0x116
#define	VESA_1280x1024x15	0x119
// HiColor
#define	VESA_320x200x16		0x10E
#define	VESA_640x480x16		0x111
#define	VESA_800x600x16		0x114
#define	VESA_1024x768x16	0x117
#define	VESA_1280x1024x16	0x11A
// TrueColor
#define	VESA_320x200x24		0x10F
#define	VESA_640x480x24		0x112
#define	VESA_800x600x24		0x115
#define	VESA_1024x768x24	0x118
#define	VESA_1280x1024x24 	0x11B
// TrueColor
#define	VESA_320x200x32		0x10F
#define	VESA_640x480x32		0x112
#define	VESA_800x600x32		0x115
#define	VESA_1024x768x32	0x118
#define	VESA_1280x1024x32 	0x11B


struct VESAInfo
{
  char VESA[4];
  int Version;
  char far *OEM;
  long Capabilities;
  int far *ModeList;
  int VideoMemory;
  int Version1;
  char far *Firma;
  char far *Name;
  char far *Version2;
  char Reserved[222];
};

struct VESAModeInfo
{
  int ModeAttributes;
  char WinAAttributes;
  char WinBAttributes;
  int WinGranularity;
  int WinSize;
  unsigned WinASegment;
  unsigned WinBSegment;
  void far *WinFuncPtr;
  int BytesPerScanLine;
  int XResolution;
  int YResolution;
  char XCharSize;
  char YCharSize;
  char PlanesCount;
  char BitsPerPixel;
  char BanksCount;
  char MemoryModel;
  char BankSize;
  char PageCount;
  char Reserved;
  char RedMaskSize;
  char RedFieldPosition;
  char GreenMaskSize;
  char GreenFieldPosition;
  char BlueMaskSize;
  char BlueFieldPosition;
  char RsvdMaskSize;
  char RsvdFieldPosition;
  char DirectColorModeInfo;
  char Resererved2[216];
};

class VESA
{
  char fVESA;
  int CurrentBank;
  int BytesPerScanLine;
  char BytesPerPixel;
  char Rr; // shift right
  char Rl; // shift left
  char Gr;
  char Gl;
  char Br;
  char Bl;
  //long BankStepByte;
  //int BankSize;
 public:
  VESA();
  char Is();
  char IsMode(int);
  char SetMode(int);
  char GetInfo(VESAInfo&);
  char GetModeInfo(int, VESAModeInfo&);
  char SetBank(int);
  void PutPixel(int, int, Color);
};

void SetMode(char);
void SetTextMode();

#endif