#include "vesa.h"

#include <string.h>
#include <dos.h>

char VESA::Is()
{
  VESAInfo VI;
  fVESA = !GetInfo(VI) && !strncmp(VI.VESA,"VESA",4);
  return fVESA;
}

VESA::VESA()
{
  Is();
}

char VESA::IsMode(int Mode)
{
  VESAInfo VI;
  GetInfo(VI);
  for (int i=0; VI.ModeList[i]!=-1; i++)
    if (VI.ModeList[i]==Mode)
      {
	VESAModeInfo VMI;
	return !GetModeInfo(Mode,VMI);
      }
  return 0;
}

char VESA::GetInfo(VESAInfo& VI)
{
  VI.VESA[0]='V';
  VI.VESA[1]='B';
  VI.VESA[2]='E';
  VI.VESA[3]='2';
  asm {
	push	ES
	push	DI
	les	DI,VI
	mov	AX,0x4F00
	int	0x10
	pop	DI
	pop	ES
  }
  return _AX!=0x004F;
}

char VESA::GetModeInfo(int Mode, VESAModeInfo& VMI)
{
  if (fVESA)
    {
      asm {
	push	ES
	push	DI

	les	DI,VMI
	mov	AX,0x4F01
	mov	CX,Mode
	int	0x10

	pop	DI
	pop	ES
      }
      return _AX!=0x004F;
    }
  else
    return 1;
}

char VESA::SetMode(int Mode)
{
  if (fVESA)
    {
      VESAModeInfo VMI;
      GetModeInfo(Mode,VMI);
      BytesPerScanLine = VMI.BytesPerScanLine;
      BytesPerPixel = (VMI.BitsPerPixel+7)/8;

      //BankSize = VMI.WinSize;
      //BankStepByte = (long)VMI.WinGranularity*1024;

      Rr = 8 - VMI.RedMaskSize;
      Rl = VMI.RedFieldPosition;
      Gr = 8 - VMI.GreenMaskSize;
      Gl = VMI.GreenFieldPosition;
      Br = 8 - VMI.BlueMaskSize;
      Bl = VMI.BlueFieldPosition;

      asm {
	mov	AX,0x4F02
	mov	BX,Mode
	int	0x10
      }
      return _AX!=0x004F;
    }
  else
    return 1;
}

char VESA::SetBank(int Bank)
{
  if (Bank==CurrentBank)
    return 0;
  else
    {
      CurrentBank = Bank;
      asm {
	mov	AX,0x4F05
	xor	BX,BX
	mov	DX,Bank
	int	0x10
      }
      return _AX!=0x004F;
    }
}

// Only True Color
/*
void VESA::PutPixel(int x, int y, Color c)
{
  long Addr = (long)BytesPerScanLine*(long)y + BytesPerPixel*(long)x;
  // ⠥,  ࠧ  64K
  SetBank(Addr>>16);
  pokeb(0xA000, Addr++, c.B*255);
  SetBank(Addr>>16);
  pokeb(0xA000, Addr++, c.G*255);
  SetBank(Addr>>16);
  pokeb(0xA000, Addr, c.R*255);
}
*/

// True Color and Hi Color
void VESA::PutPixel(int x, int y, Color c)
{
  long Addr = (long)BytesPerScanLine*(long)y + (long)BytesPerPixel*(long)x;
  unsigned int
    r = (int)(c.R*255)>>Rr,
    g = (int)(c.G*255)>>Gr,
    b = (int)(c.B*255)>>Br;
  unsigned long C = ( ((long)r<<Rl) | ((long)g<<Gl) | ((long)b<<Bl) );
  // ⠥,  ࠧ  64K
  SetBank(Addr>>16);
  pokeb(0xA000, Addr++, C);
  SetBank(Addr>>16);
  C>>=8;
  pokeb(0xA000, Addr, C);
  if (BytesPerScanLine>2)
  {
    SetBank((++Addr)>>16);
    C>>=8;
    pokeb(0xA000, Addr, C);
  }
}

void SetMode(char Mode)
{
  asm {
	xor	AX,AX
	mov	AL,Mode
	int	0x10
  }
}

void SetTextMode()
{
  SetMode(3);
}

