#ifndef _VECTOR_H
#define _VECTOR_H

#include <iostream.h>

#include "point.h"

// 
class Vector
{
 public:
  double X,Y,Z;
  Vector(double=0, double=0, double=0);
  Vector(const Vector&);
  Vector(const Point&);
  Vector(const Point&, const Point&);
  Vector& operator=(const Vector&);
  Vector operator-() const;
  // ୮ ஢
  char operator||(const Vector&);
  // ⢮ ஢
  char operator==(const Vector&);
  // ࠢ⢮ ஢
  char operator!=(const Vector&);
  //  
  double operator!() const;
  //  ஢
  Vector operator+(const Vector&);
  // ⠭ ஢
  Vector operator-(const Vector&) const;
  //    ᫮
  Vector operator/(const double) const;
  // ⭮ ந ஢
  Vector operator*(const Vector&);
  // ୮ ந ஢
  double operator&(const Vector&) const;
  // ୮ ந ஢
  Vector operator&&(const Vector&) const;
  //   ࠬ
  double operator^(const Vector&);
  //    ᫮
  Vector operator*(double) const;
};

Vector Normalize(const Vector&);

//    ᫮
Vector operator*(double, const Vector&);

ostream& operator<<(ostream&, Vector&);

// ६   
Point operator+(const Point&, const Vector&);

#endif