#include "vector.h"

#include <math.h>

Vector::Vector(double x, double y, double z)
{
  X = x;
  Y = y;
  Z = z;
}

Vector::Vector(const Vector& V)
{
  X = V.X;
  Y = V.Y;
  Z = V.Z;
}

Vector::Vector(const Point& P)
{
  X = P.X;
  Y = P.Y;
  Z = P.Z;
}

Vector::Vector(const Point& P1, const Point& P2)
{
  X = P2.X - P1.X;
  Y = P2.Y - P1.Y;
  Z = P2.Z - P1.Z;
}

Vector& Vector::operator=(const Vector& V)
{
  if (&V!=this)
    {
      X = V.X;
      Y = V.Y;
      Z = V.Z;
    }
  return *this;
}

Vector Vector::operator-() const
{
  return Vector(-X,-Y,-Z);
}

// ୮ ஢
char Vector::operator||(const Vector& V)
{
  return
    !(X*V.Y - Y*V.X) &&
    !(X*V.Z - Z*V.X) &&
    !(Y*V.Z - Z*V.Y);
}

// ⢮ ஢
char Vector::operator==(const Vector& V)
{
  return (X==V.X && Y==V.Y && Z==V.Z);
}

// ࠢ⢮ ஢
char Vector::operator!=(const Vector& V)
{
  return (X!=V.X || Y!=V.Y || Z!=V.Z);
}

//  
double Vector::operator!() const
{
  return sqrt(X*X + Y*Y + Z*Z);
}

//  ஢
Vector Vector::operator+(const Vector& V)
{
  return Vector(X+V.X, Y+V.Y, Z+V.Z);
}

// ⠭ ஢
Vector Vector::operator-(const Vector& V) const
{
  return Vector(X-V.X, Y-V.Y, Z-V.Z);
}

//    ᫮
Vector operator*(double k, const Vector& V)
{
  return Vector(k*V.X, k*V.Y, k*V.Z);
}

//    ᫮
Vector Vector::operator*(double k) const
{
  return Vector(k*X, k*Y, k*Z);
}

//    ᫮
Vector Vector::operator/(const double k) const
{
  return Vector(X/k, Y/k, Z/k);
}

// ⭮ ந ஢
Vector Vector::operator*(const Vector& V)
{
  return Vector(X*V.X, Y*V.Y, Z*V.Z);
}

// ୮ ந ஢
double Vector::operator&(const Vector& V) const
{
  return X*V.X + Y*V.Y + Z*V.Z;
}

// ୮ ந ஢
Vector Vector::operator&&(const Vector& V) const
{
  return
    Vector(
      Y*V.Z - Z*V.Y,
      Z*V.X - X*V.Z,
      X*V.Y - Y*V.X);
}

//   ࠬ
double Vector::operator^(const Vector& V)
{
  return acos( ((*this)&V)/(!(*this))/(!V) );
}

// ६   
Point operator+(const Point& P, const Vector& V)
{
  return Point(P.X+V.X, P.Y+V.Y, P.Z+V.Z);
}

ostream& operator<<(ostream& os, Vector& V)
{
  cout<<"("<<V.X<<","<<V.Y<<","<<V.Z<<")";
  return os;
}

Vector Normalize(const Vector& V)
{
  double d = !V;
  if (d==0) d=1;
  return V/d;
}
