#ifndef _TRACE_H
#define _TRACE_H

#include "point.h"
#include "ray.h"
#include "light.h"
#include "object.h"
#include "color.h"
#include "stack.h"
#include "targa.h"
#include "vesa.h"

class Camera
{
 public:
  Point P;
  Vector I,J,K;
  Camera();
  Camera(const Point&,const Vector&,const Vector&);
  Camera(const Point&,const Vector&,const Vector&,const Vector&);
};

// 業
class Scene
{
 public:
  Camera Cam;		//  ⥫
  Light *Lights;	// ᮪ 筨 ᢥ
  Object *Objects;	// ᮪ ᪨ ꥪ⮢
  Scene();
  ~Scene();
  Color GetI(StackItem&);
  Color Trace(Ray);
  Object* Intersect(const Ray&,double&,Point&);
  char Show(int,int,int,int,VESA*,Targa*);
  Scene& operator<<(Light* L);
  Scene& operator<<(Object* L);
  Scene& operator<<(Camera L);
};

// ᫥ ࠦ񭭮 
Vector Reflected(const Vector&, const Vector&);

// ᫥ ५񭭮 
char Refracted(const Vector&, const Vector&, double, Vector&);

#endif