#include "trace.h"

#include <values.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>

#include "math1.h"
#include "error.h"
#include "property.h"

Camera::Camera()
{
  P = Point(0,0,0);
  I = Vector(1,0,0);
  J = Vector(0,-1,0);
  K = Vector(0,0,1);
}

Camera::Camera(const Point& p, const Vector& Dir,const Vector& Up)
{
  P = p;
  K = Normalize(Dir);
  I = Normalize(Up && Dir);	//୮ ந
  J = -Normalize(K && I);
}

Camera::Camera(const Point& p,
	       const Vector& i, const Vector& j, const Vector& k)
{
  P = p;
  I = Normalize(i);
  J = -Normalize(j);
  K = Normalize(k);
}

Scene::Scene()
{
  Lights = NULL;
  Objects = NULL;
}

Scene::~Scene()
{
  Check("Scene::~Scene");
}

//   業  筨 ᢥ
Scene& Scene::operator<<(Light* L)
{
  L->Next = Lights;
  Lights = L;
  return *this;
}

//   業  ᪮ ꥪ
Scene& Scene::operator<<(Object* G)
{
  G->Next = Objects;
  Objects = G;
  return *this;
}

// ⠭ 
Scene& Scene::operator<<(Camera cam)
{
  Cam = cam;
  return *this;
}

//  ꥪ,      ﭨ  窨
//  祭
Object* Scene::Intersect(const Ray& ray, double& d, Point& P)
{
  Object* Obj = NULL;
  d = MAXDOUBLE;	// 砩襥 ﭨ
  double s;
  Point p;
  for (Object* T=Objects; T!=NULL; T=T->Next)
    if (T->Intersect(ray, s, p))
      if (s < d)
	{
	  d = s;
	  Obj = T;
	  P = p;
	}
  return Obj;
}

// v -   ࠢ 饣 
// n -   ଠ  窥  
// ᫥ ࠦ񭭮 
Vector Reflected(const Vector& v, const Vector& n)
{
  return v - 2*(v&n)*n;
}

// v -   ࠢ 饣 
// n -   ଠ  窥  
// eta - ⥫ ५ ன । ⭮⥫쭮 ࢮ
// ᫥ ५񭭮 
char Refracted(const Vector& v, const Vector& n, double eta, Vector& p)
{
  double
    c = (-v)&n,
    d = 1 + sqr(eta)*(sqr(c)-1);
  if (d<0)
    return 0;
  else
    {
      p = Normalize(eta*v + (eta*c - sqrt(d))*n);
      return 1;
    }
}

#define Ia Color(1, 1, 1)

// L -    窨 孮  筨
// R -   ࠦ񭭮  窨 孮 
// S -    ⥫  窥 孮
// n -   ଠ  窨 孮

#define LightThreshold 0.05

// ᫥ ⥭ᨢ 窨
Color Scene::GetI(StackItem& SI)
{
  Color
    I = Black,
    Ij;  // ⥭ᨢ 筨 ᢥ
  Vector
    V,
    Lj,	 //    窨 孮  筨
    S,	 //    ⥫  窥 孮
    Rj;	 //   ࠦ񭭮  窨 孮 

  SurfaceProperty SP = SI.Obj->SP;

  char
    flag,
    m;	// ⥪騩 ਠ

  Point P;
  double d,dt;
  Object *Obj;

  for (Light* L=Lights; L!=NULL; L=L->Next)
    {
      Lj = Normalize(Vector(SI.P, L->C));
      Ij = L->I;
      flag = 1;

      // ஢   筨  窥 孮,
      // 㬥 મ
      P = L->C;
      V = Vector(P, SI.P);
      dt = !V;
      // ।,  筨 ᢥ  㬥
      m = Vacuum;
      while ((Obj=Intersect(Ray(P,V),d,P))!=NULL && dt>GeomThreshold)
	{
	  Ij = Ij * exp(-d * Material(m).Kabs);
	  if (Ij.R<=LightThreshold)
	    if (Ij.G<=LightThreshold)
	      if (Ij.B<=LightThreshold)
	      {
		flag = 0;
		break;
	      }
	  m = Obj->M12 - m;
	  dt = dt - d;
	}
      if (flag)
	{
	  Ij.Clip();
	  S = -SI.Dir;
	  Rj = Reflected(-Lj, SI.n);
	  I = I + SI.Obj->I * SP.Kd * Ij * (SI.n&Lj);
	  I = I + SP.Ks * Ij * pow((S&Rj), SP.p);
	}
    }

  I = (I + SP.Ka*Ia*SI.Obj->I + SP.Ks*SI.Is + SP.Kt*SI.It)
    * exp(-SI.d * Material(SI.M).Kabs);

  I.Clip();

  return I;
}

#undef Ia

// ஢ 
Color Scene::Trace(Ray R)
{
  char fReflected = 0;
  Stack S;
  StackItem SI;
  Color I;

  SI.Type = v;
  SI.Obj = NULL;
  SI.Dir = R.Dir;
  SI.P = R.P;
  SI.d = 0;
  SI.It = Black;
  SI.Is = Black;
  SI.M = Vacuum;

  S<<SI;
  while (!S.Empty())	//  ⥪  
    {
      S>>SI;   		//    ⥪
      if (SI.Obj==NULL)
	if ((SI.Obj=Intersect(Ray(SI.P, SI.Dir), SI.d, SI.P))==NULL)
	  if (SI.Type==v)
	    I = Black;	// 
	  else
	    if (SI.Type==r)
	      fReflected = 1;
	    else;
	else	//  祭
	  {
	    SI.n = SI.Obj->Normal(SI.P);

	    if ((SI.n&SI.Dir)>0)	// 室  ꥪ
	      SI.n = -SI.n;

	    S<<SI;

	    if (!S.Full())
	      {
		SI.Type = r;
		SI.Dir = Reflected(SI.Dir, SI.n);
		SI.Obj = NULL;
		// SI.P - 砫 
		SI.d = 0;
		SI.It = Black;
		SI.Is = Black;
		// ࠦ   室  㣮 ਠ
		//   ⥪ ࠦ 
		S<<SI;
	      }
	  }
      else  //   祭
	{
	  I = GetI(SI);
	  if (SI.Type==r)
	    {
	      S.Look()->Is = I;
	      fReflected = 1;
	    }
	  else
	    if (SI.Type==p)
	      S.Look()->It = I;
	}

      if (fReflected)
	{
	  if (!S.Full())
	    {
	      StackItem *Base = S.Look();
	      SI.M = Base->Obj->M12 - Base->M;
	      if (Refracted(Base->Dir, Base->n,
		  Material(Base->M).Eta/Material(SI.M).Eta, SI.Dir))
		{
		  SI.Type = p;
		  SI.Obj = NULL;
		  SI.P = Base->P;
		  SI.d = 0;
		  SI.It = Black;
		  SI.Is = Black;

		  //   ⥪ ५ 
		  S<<SI;
		}
	    }
	  fReflected = 0;
	}
    }
  return I.Clip();
}

// ࠦ 業  ࠭
char Scene::Show(int x1, int y1, int x2, int y2, VESA* V, Targa* TGA)
{
  char
    fComplete=1;
  int
    x,y,
    xc=(x1+x2)/2,
    yc=(y1+y2)/2;
  Color C,Ct;
  Color *Cs = new Color[x2-x1+1];
  Color C1 = Black;
  memset(Cs,0,sizeof(*Cs));
  Ray R;
  R.Dir = Cam.K;
  //for (y=y1; y<y2; y++)
    //V->PutPixel(0,y,0.4*White);
  for (y=y1; y<y2; y++)
    {
      for (x=x1; x<x2; x++)
	{
	  R.P = Cam.P + (x-xc)*Cam.I + (y-yc)*Cam.J;
	  Ct = Trace(R);
	  C = (Cs[x-x1] + Cs[x-x1+1] + Ct + C1)/4;
	  V->PutPixel(x,y,C);
	  TGA->PutPixel(C);
	  Cs[x-x1] = C1;
	  C1 = Ct;
	}
      //V->PutPixel(0,y,White);
      if (kbhit())
      {
	fComplete = 0;
	break;
      }
    }
  delete[] Cs;
  return fComplete;
}