#include "targa.h"
#include "error.h"

#include <string.h>

Targa::Targa(char* FN, int width, int height, char* comment)
{
  if ((F=fopen(FN,"wb"))==NULL) error(18,FN);

  TGA_Header Hdr;
  memset(&Hdr,0,sizeof(Hdr));

  Hdr.DataType = 2;
  Hdr.Width    = width;
  Hdr.Height   = height;
  Hdr.DataBits = 24;
  Hdr.ImType   = 32;

  if (comment[0]!='\0')
    Hdr.TextSize = strlen(comment)+1;

  fwrite(&Hdr, sizeof(Hdr), 1, F);

  if (Hdr.TextSize>0)
    fwrite(comment, sizeof(char), Hdr.TextSize, F);
}

Targa::~Targa()
{
  fclose(F);
}

void Targa::PutPixel(Color C)
{
  char x = C.B*255;
  fwrite(&x, 1, 1, F);
  x = C.G*255;
  fwrite(&x, 1, 1, F);
  x = C.R*255;
  fwrite(&x, 1, 1, F);
}
