#ifndef _STACK_H
#define _STACK_H

#include "object.h"
#include "color.h"
#include "vector.h"
#include "point.h"

#define MAX_STACK_LEVEL 4	// ᨬ ஢ ⥪

//  
typedef enum
{
  v,	// , 室騩   ⥫  室騩 १ ᥫ
  r,	// ࠦ 
  p	// ५ 
} RayType;

class StackItem
{
 public:
  RayType Type;	 //   (v, r, p)

  Object* Obj;	 // ꥪ,   祭,
		 // ᫨  祭,  Obj = NULL

  Vector Dir;	 //   ࠢ 

  Point P;	 // ᫨ Obj==NULL,  P - 砫 ;
		 // ᫨ Obj!=NULL,  P - 窠 祭   Obj

  double d;	 // ﭨ  祭 室  
		 //  祭 

  Color It;	 // ⥭ᨢ ய饭 ᢥ
		 //   ࠢ  

  Color Is;	 // ⥭ᨢ ઠ쭮 ࠦ񭭮 ᢥ
		 //   ࠢ  

  char M;	 // ਠ,  ᮤন 

  Vector n;	// ଠ  孮  窥 P

  StackItem* Link;	//   ⥪

  StackItem();
};

// ⥪
class Stack
{
 public:
  StackItem *Top;	// 設 ⥪
  int Count;		// 饥 ⢮ ⮢  ⥪
  int MaxCount;		// ᨬ쭮  㡨 ⥪
  Stack();
  ~Stack();
  char Empty();		// 1 - ᫨ ⥪ 
  char Full();		// 1 - ᫨ ⥪ 
  void Put(const StackItem&);	// 饭  ⥪
  StackItem* Look();	// 頥   設 ⥪  祭
  StackItem Get();	// 祭  ⥪
};

void operator<<(Stack&, const StackItem&);
void operator>>(const StackItem&, Stack&);
StackItem& operator>>(Stack&, StackItem&);
StackItem& operator<<(StackItem&, Stack&);

#endif