#include "stack.h"

#include "error.h"

StackItem::StackItem()
{
  Link = NULL;
}

Stack::Stack()
{
  Top = NULL;
  Count = 0;
  MaxCount = MAX_STACK_LEVEL;
}

Stack::~Stack()
{
  while (Count)
    Get();
}

char Stack::Empty()
{
  return Count<=0;
}

char Stack::Full()
{
  return Count>=MaxCount;
}

StackItem* Stack::Look()
{
  return Top;
}

void Stack::Put(const StackItem& SI)
{
  if (Count<MaxCount)
    {
      StackItem* New = new StackItem(SI);
      New->Link = Top;
      Count++;
      Top = New;
    }
  else
    error(6);
  Check("Stack::Put");
}

void operator<<(Stack& S, const StackItem& SI)
{
  S.Put(SI);
}

void operator>>(const StackItem& SI, Stack& S)
{
  S.Put(SI);
}

StackItem Stack::Get()
{
  StackItem I = *Top;
  if (Count)
    {
      delete Top;
      Count--;
      Top = I.Link;
    }
  else
    error(5);
  Check("Stack::Get");
  return I;
}

StackItem& operator>>(Stack& S, StackItem& SI)
{
  return SI=S.Get();
}

StackItem& operator<<(StackItem& SI, Stack& S)
{
  return SI=S.Get();
}