#include "sphere.h"

#include <math.h>
#include "math1.h"

Sphere::Sphere(const Point& P, double r)
{
  C = P;
  R = r;
  RR = r*r;
}

char Sphere :: Intersect (const Ray& ray, double& t, Point& P)
{
  double t1,t2;
  char
    i = SquareEq(
      sqr(ray.Dir.X) + sqr(ray.Dir.Y) + sqr(ray.Dir.Z),
      2*(ray.P.X*ray.Dir.X + ray.P.Y*ray.Dir.Y + ray.P.Z*ray.Dir.Z),
      sqr(ray.P.X) + sqr(ray.P.Y) + sqr(ray.P.Z) - RR,
      t1, t2);
  if (!i) return 0;

  P = ray.P + t1*ray.Dir;
  if (t1>GeomThreshold)
    {
      t = t1;
      return 1;
    }
  if (i==1) return 0;

  P = ray.P + t2*ray.Dir;
  if (t2>GeomThreshold)
    {
      t = t2;
      return 1;
    }
  else
    return 0;

}

Vector Sphere::Normal(const Point& P)
{
  return Vector(C,P)/R;
}
