#include "ring.h"
#include "math1.h"

Ring::Ring(Plane Pl, Point p, double r1, double r2): Plane(Pl)
{
  P = p;
  R1 = r1;
  R2 = r2;
  if (R1>R2) swap(R1,R2);
}

Ring::Ring(Point p, Vector v, double r1, double r2): Plane(p,v)
{
  P = p;
  R1 = r1;
  R2 = r2;
  if (R1>R2) swap(R1,R2);
}

char Ring::Intersect(const Ray& ray, double& d, Point& P1)
{
  if (Plane::Intersect(ray,d,P1))
    {
      double r = (P,P1);
      return (R1<r)&&(r<R2);
    }
  else
    return 0;
}

Vector Ring::Normal(const Point&)
{
  return n;
}