#include "rectangl.h"
#include "math1.h"

Rectangle::Rectangle(Point P1,Point P2,Point P3,Point P4):Plane(P1,P2,P3)
{
  h1 = P1.Y;
  h2 = P3.Y;
  double dy = h2 - h1;
  r0 = (P1,P2)/2;
  kr = ((P3,P4)/2-r0)/dy;
  Point
    P12 = (P1+P2)/2,
    P34 = (P3+P4)/2;
  x0 = P12.X;
  z0 = P12.Z;
  kx = (P34.X - x0)/dy;
  kz = (P34.Z - z0)/dy;
}

char Rectangle::Intersect(const Ray& ray, double& d, Point& P)
{
  if (Plane::Intersect(ray,d,P))
    if (P.Z>h1 && P.Z<h2)
      return ( P, Point(x0 + kx*(P.Z-h1), P.Y, z0+(kz*P.Z-h1)) )
	< (r0 + kr*(P.Z-h1));
    else
      return 0;
  else
    return 0;
}

Vector Rectangle::Normal(const Point&)
{
  return n;
}