#include "rect.h"

#include <graphics.h>

PointXY::PointXY()
{
  Assign(0,0);
}

void PointXY::Assign(int x, int y)
{
  X = x;
  Y = y;
}

PointXY::PointXY(int x, int y)
{
  Assign(x,y);
}

void PointXY::Draw(int color)
{
  putpixel(X, Y, color);
}

void PointXY::OutText(char *str)
{
  outtextxy(X, Y, str);
}

PointXY PointXY::operator+(PointXY p)
{
  return PointXY(X+p.X, Y+p.Y);
}

PointXY& PointXY::operator=(PointXY p)
{
  X = p.X;
  Y = p.Y;
  return *this;
}

char PointXY::operator==(PointXY p)
{
  return (X==p.X) && (Y==p.Y);
}

char PointXY::operator!=(PointXY p)
{
  return (X!=p.X) || (Y!=p.Y);
}

TRect::TRect()
{
  dX = 0;
  dY = 0;
}

TRect::TRect(PointXY p, int dx, int dy)
{
  Assign(p, dx, dy);
}

void TRect::TRect(int x, int y, int dx, int dy)
{
  Assign(x, y, dx, dy);
}

void TRect::Assign(PointXY p, int dx, int dy)
{
  P = p;
  dX = dx;
  dY = dy;
}

void TRect::Assign(int x, int y, int dx, int dy)
{
  P.Assign(x, y);
  dX = dx;
  dY = dy;
}

void TRect::Rectangle(int color)
{
  setcolor(color);
  Rectangle();
}

void TRect::Rectangle()
{
  rectangle(P.X, P.Y, P.X+dX, P.Y+dY);
}

void TRect::Bar(int color)
{
  setfillstyle(SOLID_FILL,color);
  bar(P.X, P.Y, P.X+dX, P.Y+dY);
}

void TRect::Bar()
{
  bar(P.X, P.Y, P.X+dX, P.Y+dY);
}

void TRect::Border(int Active)
{
  if (Active)
    Active = BLACK;
  else
    Active = WHITE;
  setcolor(Active);
  line(P.X-1, P.Y-1, P.X+dX+1, P.Y-1);
  line(P.X-1, P.Y-1, P.X-1, P.Y+dY+1);

  setcolor(WHITE+BLACK-Active);
  line(P.X+dX+1, P.Y-1, P.X+dX+1, P.Y+dY+1);
  line(P.X-1, P.Y+dY+1, P.X+dX+1, P.Y+dY+1);
}

void TRect::Button(int Active)
{
  setcolor(DARKGRAY);
  if (Active)
    {
      line(P.X, P.Y, P.X+dX, P.Y);
      line(P.X, P.Y, P.X, P.Y+dY);
      //putpixel(P.X+dX+1, P.Y, LIGHTGRAY);
      //putpixel(P.X, P.Y+dY+1, LIGHTGRAY);
      Active = BLACK;
    }
  else
    {
      line(P.X+dX+1, P.Y, P.X+dX+1, P.Y+dY);
      line(P.X, P.Y+dY+1, P.X+dX+1, P.Y+dY+1);
      Active = WHITE;
    }
  setcolor(Active);
  line(P.X-1, P.Y-1, P.X+dX+1, P.Y-1);
  line(P.X-1, P.Y-1, P.X-1, P.Y+dY+1);

  setcolor(WHITE+BLACK-Active);
  line(P.X+dX+2, P.Y-1, P.X+dX+2, P.Y+dY+1);
  line(P.X-1, P.Y+dY+2, P.X+dX+2, P.Y+dY+2);
}

void TRect::OutText(char *str)
{
  settextjustify(CENTER_TEXT,CENTER_TEXT);
  outtextxy(P.X + dX/2, P.Y + dY/2, str);
}

TRect TRect::operator+(PointXY p)
{
  return TRect(P+p,dX,dY);
}

TRect& TRect::operator=(TRect R)
{
  P = R.P;
  dX = R.dX;
  dY = R.dY;
  return *this;
}

char TRect::In(PointXY p)
{
  return p.X >= P.X && p.Y >= P.Y && p.X <= P.X+dX && p.Y <= P.Y+dY;
}
