#include "point.h"

#include <math.h>
#include "math1.h"

Point::Point(double x, double y, double z)
{
  X = x;
  Y = y;
  Z = z;
}

Point::Point(const Point& V)
{
  X = V.X;
  Y = V.Y;
  Z = V.Z;
}

Point& Point::operator=(const Point& V)
{
  if (&V!=this)
    {
      X = V.X;
      Y = V.Y;
      Z = V.Z;
    }
  return *this;
}

Point Point::operator-(const Point& P)
{
  return Point(X-P.X, Y-P.Y, Z-P.Z);
}

Point Point::operator+(const Point& P)
{
  return Point(X+P.X, Y+P.Y, Z+P.Z);
}

Point Point::operator/(const double k)
{
  return Point(X/k, Y/k, Z/k);
}

// ﭨ  窠
double Point::operator,(const Point& P)
{
  return sqrt( sqr(P.X-X) + sqr(P.Y-Y) + sqr(P.Z-Z) );
}

ostream& operator<<(ostream& os, Point& V)
{
  cout<<"("<<V.X<<","<<V.Y<<","<<V.Z<<")";
  return os;
}
