#include "matrix.h"

Matrix Matrix::operator+(const Matrix& M)
{
  Matrix R;
  for (int i=0; i<4; i++)
    for (int j=0; j<4; j++)
      R.x[i][j] = x[i][j] + M.x[i][j];
  return R;
}

Matrix Matrix::operator-(const Matrix& M)
{
  Matrix R;
  for (int i=0; i<4; i++)
    for (int j=0; j<4; j++)
      R.x[i][j] = x[i][j] - M.x[i][j];
  return R;
}

Matrix Matrix::operator*(double K)
{
  Matrix R;
  for (int i=0; i<4; i++)
    for (int j=0; j<4; j++)
      R.x[i][j] = K * x[i][j];
  return R;
}

Matrix Matrix::operator*(const Matrix& M)
{
  Matrix R;
  double S;
  for (int i=0; i<4; i++)
    for (int j=0; j<4; j++)
      {
	S = 0;
	for (int k=0; k<4; k++)
	  S += x[i][k] * M.x[k][j];
	R.x[i][j] = S;
      }
  return R;
}

ostream& operator<<(ostream& os, Matrix& M)
{
  cout.setf(ios::showpos);
  cout.setf(ios::left);
  for (int i=0; i<4; i++)
    {
      switch (i)
	{
	  case 0: os<<""; break;
	  case 3: os<<""; break;
	  default: os<<""; break;
	}
      for (int j=0; j<4; j++)
	os<<" "<<M.x[i][j];
      switch (i)
	{
	  case 0: os<<""; break;
	  case 3: os<<""; break;
	  default: os<<""; break;
	}
      os<<endl;
    }
  return os;
}