#include "cylinder.h"

#include "math1.h"
#include <math.h>

Cylinder::Cylinder(double r, double h1, double h2)
{
  H1 = h1;
  H2 = h2;
  if (H1>H2)
    swap(H1,H2);
  R = r;
  RR = R*R;
}

char Cylinder::Intersect(const Ray& ray, double& t, Point& P)
{
  //if (ray.Dir.X==0 && ray.Dir.Z==0) return 0;
  double t1,t2;
  char
    i = SquareEq(
      sqr(ray.Dir.X) + sqr(ray.Dir.Z),
      2*(ray.P.X*ray.Dir.X + ray.P.Z*ray.Dir.Z),
      sqr(ray.P.X) + sqr(ray.P.Z) - RR,
      t1, t2);
  if (!i) return 0;

  P = ray.P + t1*ray.Dir;
  if (t1>GeomThreshold && H1<P.Y && P.Y<H2)
    {
      t = t1;
      return 1;
    }
  if (i==1) return 0;

  P = ray.P + t2*ray.Dir;
  if (t2>GeomThreshold && H1<P.Y && P.Y<H2)
    {
      t = t2;
      return 1;
    }
  else
    return 0;
}

Vector Cylinder::Normal(const Point& P)
{
  return Normalize(Vector(P.X,0,P.Z));
}
