#include "color.h"

void Color::Clip(double& i)
{
  if (i<0) i = 0;
  else
    if (i>1)
      i = 1;
}

Color Color::Clip()
{
  Clip(R);
  Clip(G);
  Clip(B);
  return *this;
}

Color::Color(double r, double g, double b)
{
  R = r;
  G = g;
  B = b;
}

Color::Color(const Color& C)
{
  R = C.R;
  G = C.G;
  B = C.B;
}

Color& Color::operator=(const Color& C)
{
  if (&C!=this)
    {
      R = C.R;
      G = C.G;
      B = C.B;
    }
  return *this;
}

char Color::operator==(const Color& C)
{
  return R==C.R && G==C.G && B==C.B;
}

char Color::operator!=(const Color& C)
{
  return R!=C.R || G!=C.G || B!=C.B;
}

Color Color::operator+(const Color& C)
{
  return Color(R+C.R, G+C.G, B+C.B);
}

Color Color::operator*(const Color& C)
{
  return Color(R*C.R, G*C.G, B*C.B);
}

Color Color::operator*(const double k)
{
  return Color(k*R, k*G, k*B);
}

Color operator*(const double k, const Color& C)
{
  return Color(k*C.R, k*C.G, k*C.B);
}

Color Color::operator/(const double k)
{
  return Color(R/k, G/k, B/k);
}
