#include "property.h"
#include "error.h"

extern Material m_Glass;
extern Material m_Water;

SurfaceProperty::SurfaceProperty(double ka, double kd, double ks,
				 double kt, double P)
{
  Ka = ka;
  Kd = kd;
  Ks = ks;
  Kt = kt;
  p  = P;
}

SurfaceProperty::SurfaceProperty()
{
}

Material::Material(double eta, double kabs)
{
  Eta = eta;
  Kabs = kabs;
}

Material::Material()
{
}

Material::Material(char No)
{
  switch (No)
    {
      case Vacuum:
	Eta = 1.00029;
	Kabs = 0;
	break;
      case Water:
	(*this) = m_Water;
	break;
      case Glass:
	(*this) = m_Glass;
	break;
      default:
	//error(" ਠ");
	Eta = 1;
	Kabs = 0;
      break;
    }
}
