//
//
//  Copyright (c) KES_Company, 1997

#ifndef __HUGE__
#error Model - Huge
#endif

#include <stdlib.h>
#include <iostream.h>
#include <alloc.h>
#include <conio.h>
#include <graphics.h>
#include <stdio.h>
#include <new.h>
#include <dos.h>
#include <io.h>
#include <string.h>
#include <time.h>
#include <dir.h>

#include "error.h"
#include "mouse.h"
#include "rect.h"
#include "keys.h"
#include "math1.h"
#include "c_kes_co.h"

#include "trace.h"
#include "objects.h"
#include "vesa.h"
#include "targa.h"

#define MAXINT 32767

#define PictDat "PICT\\pict_num.dat"

static int fSpeed = 0;
static int Text_Cursor_Color = EGA_MAGENTA^EGA_WHITE;
   // ⥪⮢    䮭
static int Window_Move_Color = EGA_GREEN^EGA_BLACK;
   //   ६饭   ୮ 䮭

int XAsp,YAsp;

char* InputLine;

typedef unsigned int Command;

SurfaceProperty               //Ka   Kd   Ks   Kt   p
  Surf_Glass = SurfaceProperty(  1, 0.2, 0.5, 0.8, 10),
  Surf_Water = SurfaceProperty(  1, 0, 0.5, 1, 10);

Material
  m_Glass = Material(1.5, 0.01),
  m_Water = Material(1.33, 0.0);

Color
  Color_Glass = Color(0, 0, 0.3),
  Color_Water = Color(0, 1, 0);

#define X_MIN	200
#define Y_MIN	0//100
#define X_MAX	400
#define Y_MAX	480//400

void NearHeapSize()
{
  unsigned long count;
  struct heapinfo info;
  info.ptr = NULL;
  if (heapcheck()!=_HEAPOK) error(9,"NearHeapSize");
  count = coreleft();
  while (heapwalk(&info)==_HEAPOK)
    if (info.in_use==0)
      count+=info.size;
  char Str[33];
  ultoa(count,Str,10);
  setcolor(EGA_WHITE);
  settextjustify(LEFT_TEXT,TOP_TEXT);
  outtextxy(2,2,Str);
}

char UpCase(char c)
{
  if ((c>='a' && c<='z')  // 쪠 ⨭᪠ 㪢
  || (c>='' && c<=''))  // 쪨 ᪨ 㪢 : ..
    return c-32;
  else
  if (c>='' && c<='')   // 쪨 ᪨ 㪢 : ..
    return c-80;
  else
  if (c=='')  // 
    return '';
  return c;
}

void UpCase(char *Str)
{
  for (int i=0; Str[i]!=0; i++)
    Str[i]=UpCase(Str[i]);
}

//////////////////////////
//     class TEvent	//
//////////////////////////

//

#define evNull		0
#define evKeyPressed	1	//   
#define evMove		2	//६饭 
#define evLeftPressed	3	//⨥   
#define evLeftReleace	4	//᪠   
#define evRightPressed	5	//⨥ ࠢ  
#define evRightReleace	6	//᪠ ࠢ  
#define evCommand	7	//

//

#define cmExit	65535	//室  ணࠬ
#define cmTab	65534
#define cmPos	65533
#define cmMemSize 65532

char Alt()
{
  return (peekb(0,1047)&8)==8;
}

char Shift()
{
  return (peekb(0,1047)&1)==1 || (peekb(0,1047)&2)==2;
}

char ScrollLock()
{
  return (peekb(0,1047)&0x10)==0x10;
}

class TKey
{
 public:
  char Code;
  char ExtCode;
  TKey();
  TKey(char, char);
  char operator==(TKey);
};

TKey::TKey()
{
  Code = 0;
  ExtCode = 0;
}

TKey::TKey(char code, char extcode)
{
  Code = code;
  ExtCode = extcode;
}

char TKey::operator==(TKey Key)
{
  return (Code && (Code==Key.Code))||(!Code && (ExtCode==Key.ExtCode));
}

class TEvent
{
 public:
  char What;
  struct
    {
      TKey K;
      PointXY P;
      Command C;
    } Info;
  TEvent();
  void Clear();
};

TEvent::TEvent()
{
  Clear();
}

void TEvent::Clear()
{
  What = evNull;
}

//int RUSS_FONT;

void GrInit()
{
  int
    gdriver = VGA,
    gmode = VGAHI,
    errorcode;
  errorcode = registerbgidriver(EGAVGA_driver);
  if (errorcode < 0)
    error(2, grapherrormsg(errorcode));
  initgraph(&gdriver, &gmode, "");
  errorcode = graphresult();
  if (errorcode != grOk)
     error(2, grapherrormsg(errorcode));
  getaspectratio(&XAsp, &YAsp);
  //errorcode = registerbgifont(RUSS_Font);
  //RUSS_FONT = installuserfont("russ.chr");
  //if (errorcode<0) error(13,grapherrormsg(errorcode));
}

//////////////////////////
//    class THotKey	//
//////////////////////////

class THotKey
{
 public:
  TKey K;
  Command Com;
  THotKey *Next;
  THotKey();
  THotKey(Command, char, char);
  void HandleEvent(TEvent&);
};

THotKey::THotKey()
{
  Com = 0;
  Next = NULL;
}

THotKey::THotKey(Command com, char code, char extcode=0)
{
  K.Code = code;
  K.ExtCode = extcode;
  Com = com;
  Next = NULL;
}

void THotKey::HandleEvent(TEvent& Event)
{
  if (Event.What==evKeyPressed)
    if (Event.Info.K==K)
      {
	Event.What = evCommand;
	Event.Info.C = Com;
      }
}

//////////////////////////
//     class TKeys	//
//////////////////////////

class TKeys
{
 public:
   THotKey *First;	//吝 ᯨ᮪
   int Step;		//   樨  
   char fRightPressed;
   TKeys();
   ~TKeys();
   void Add(Command, char, char);
   void HandleEvent(TEvent&);
};

TKeys::TKeys()
{
  First = NULL;
  Step = 5;
  fRightPressed = 0;
}

TKeys::~TKeys()
{
  THotKey
    *TNext,
    *T = First;
  while (T!=NULL)
    {
      TNext = T->Next;
      delete T;
      T = TNext;
    }
}

void TKeys::Add( Command command, char code, char extcode=0 )
{
  THotKey* New=new THotKey(command, code, extcode);
  New->Next = First;
  First = New;
}

void TKeys::HandleEvent(TEvent &Event)
{
  for (THotKey *T=First; T!=NULL; T=T->Next)
    T->HandleEvent(Event);
  if (Event.What==evKeyPressed)
    {
      int X,Y,mk;
      char fMouse = 0;
      GetMouseCoo(X,Y,mk);
      switch (Event.Info.K.Code)
	{
	  case 0:
	    switch (Event.Info.K.ExtCode)
	      {
		case kbRight: //Right
		  X += Step;
		  fMouse = 1;
		  break;
		case kbLeft: //Left
		  X -= Step;
		  fMouse = 1;
		  break;
		case kbUp: //Up
		  Y -= Step;
		  fMouse = 1;
		  break;
		case kbDown: //Down
		  Y += Step;
		  fMouse = 1;
		  break;
		case kbAltX: // Alt+X
		  Event.What = evCommand;
		  Event.Info.C = cmExit;
		  break;
	      }
	    break;
	  case kbGrayPlus: //Gray Plus
	    if (Step<100) Step+=1;
	    break;
	  case kbGrayMinus: //Gray Minus
	    if (Step>1) Step-=1;
	    break;
	  case '*': // *
	    if (Step<100) Step*=2;
	    break;
	  case '/': // /
	    if (Step>1) Step/=2;
	    break;
	  case kbEnter: //Enter
	    Event.What = evLeftReleace;
	    break;
	  case kbTab: //Tab
	    Event.What = evCommand;
	    Event.Info.C = cmTab;
	    break;
	}
      if (fMouse)
	SetMouseCoo(X,Y);
    }
  if (Event.What<evCommand)
    if (Shift())
      {
	Event.What = evRightPressed;
	fRightPressed = 1;
      }
    else
      if (fRightPressed)
	{
	  Event.What = evRightReleace;
	  fRightPressed = 0;
	}
}

//////////////////////////////////////////

char In(char c, char* Str)
{
  char Flag=1;
  for (unsigned int i = 0; Str[i]!=0 && Flag; i++)
    if (Str[i]==c) Flag=0;
  return !Flag;
}

char* ReadWord(char* Str1, char* R, char* Str2)
// R - ப ᨬ-ࠧ⥫
{
  unsigned int i=0, //in Str1
	       j=0; //in Str2
  for (;  In(Str1[i],R) && Str1[i]!=0; i++);
  for (; !In(Str1[i],R) && Str1[i]!=0; i++)
    Str2[j++]=Str1[i];
  Str2[j]=0;
  //in Str1: j < i
  for (j=0; Str1[i]!=0; i++)
    Str1[j++]=Str1[i];
  Str1[j]=0;
  return Str1;
}

int ReadWord(char* Str, char* R, int& i)
{
  char word[80];
  ReadWord(Str,R,word);
  i = atoi(word);
  return i;
}

char* DelChar(char* Str, char c)
//   宦 ᨬ (char c)  ப str
{
  for (unsigned int j=0,i=0; Str[i]!=0; i++)
    {
      Str[j] = Str[i];
      if (Str[i]!=c) j++;
    }
  Str[j] = 0;
  return Str;
}

char* DelChar(char *str, char *del)
{
  unsigned int i,j;
  char flag = 1;
  for (i=0; str[i]!=0 && flag; i++)
    {
      flag = 0;
      for (j=0; del[j]!=0; j++)
	if (str[i]==del[j])
	  {
	    flag = 1;
	    break;
	  }
    }
  if (str[i]!=0) i--;
  for (j=0; str[i]!=0; i++,j++)
    str[j] = str[i];
  str[j] = 0;
  return str;
}

//////////////////////////
//    class TText	//
//////////////////////////

class TText
{
 public:
  char *Text;
  int Font;
  int Direction;
  int CharSize;
  TText();
  ~TText();
  TText(char *);
  void Draw(TRect, char);
};

TText::TText()
{
  Text = NULL;
  Font = DEFAULT_FONT;
  Direction = HORIZ_DIR;
  CharSize = 0;
}

TText::~TText()
{
  if (Text!=NULL) delete[] Text;
}

void TText::TText(char *str)
{
  char Str[80];			//char Z[]=", ";
  Font = DEFAULT_FONT;		//ReadWord(str, Z, Font);
  Direction = HORIZ_DIR;	//ReadWord(str, Z, Direction);
  CharSize = 0;			//ReadWord(str, Z, CharSize);
  DelChar(str,", \"");
  ReadWord(str,"\"",Str);
  Text = new char[strlen(Str)+1];
  strcpy(Text,Str);
}

void TText::Draw(TRect R, char Active)
{
  //if (textwidth(Text)>R.dX)
    //settextstyle(Font, VERT_DIR, CharSize);
  //else
  settextstyle(Font, HORIZ_DIR, CharSize);
  TRect R1(R.P.X-Active, R.P.Y-Active, R.dX, R.dY);
  R.Bar(EGA_LIGHTGRAY);
  setcolor(EGA_BLACK);
  R1.OutText(Text);
}

//////////////////////////
//   class AI_Item	//
//////////////////////////

class AI_Item
{
 public:
  int Number;  //ID
  int Count;   //쪮 ࠧ ᯮ짮 ࠦ
  char *Name;  // 䠩
  char *Image; //ࠦ
  AI_Item *Next;
  AI_Item();
  AI_Item(char*, char*);
  void Draw(TRect R);
  ~AI_Item();
};

AI_Item::AI_Item()
{
  Number = 0;
  Count = 0;
  Name = NULL;
  Image = NULL;
  Next = NULL;
}

AI_Item::AI_Item(char* name, char* image)
{
  Number = 0;
  Count = 1;
  Image = image;
  Name = new char[strlen(name)+1];
  strcpy(Name,name);
  Next = NULL;
}

void AI_Item::Draw(TRect R)
{
  if (Image!=NULL)
    putimage(R.P.X, R.P.Y, Image, COPY_PUT);
}

AI_Item::~AI_Item()
{
  if (Name!=NULL) delete[] Name;
  if (Image!=NULL) delete[] Image;
  Check("AI_Item::~AI_Item");
}

//////////////////////////
//   class AllImages	//
//////////////////////////

class AllImages
{
 public:
  static int Count;
  static AI_Item* First;
  AllImages();
  static int AddItem(char*, char*);
  static void Delete(int);
  static int Read(char*, TRect&);
  static void Draw(int, TRect);
  static void Done();
  ~AllImages();
};

// । ᪨ ⮢ 
int AllImages::Count = 0;
AI_Item* AllImages::First = NULL;

AllImages::AllImages()
{
}

int AllImages::AddItem(char* name, char* image)
{
  AI_Item *New = new AI_Item(name,image);
  New->Number = Count;
  New->Next = First;
  First = New;
  return Count++;
}

void AllImages::Delete(int N)
{
  AI_Item
    F,
    *T = &F,
    *D;
  T->Next = First;
  while (T->Next!=NULL)
    {
      D = T->Next;
      if (D->Number==N)
	{
	  D->Count--;
	  if (!D->Count)
	    {
	      T->Next = D->Next;
	      if (D==First)
		First = D->Next;
	      delete D;
	    }
	  break;
	}
      T = D;
    }
  Check("AllImages::Delete");
}

int AllImages::Read(char* Fn, TRect& R)
{
  UpCase(Fn);

  for (AI_Item *T=First; T!=NULL; T=T->Next)
    if (strcmp(T->Name,Fn)==0)
      {
	R.dX = (int)T->Image[0] + (int)T->Image[1]*256;
	R.dY = (int)T->Image[2] + (int)T->Image[3]*256;
	T->Count++;
	return T->Number;
      }

  FILE *F;
  if ((F=fopen(Fn,"rb"))==NULL) error(3,Fn);
  long Size = filelength(fileno(F));
  char* Image = new char[Size];
  int c;
  for (long i=0; i<Size; i++)
    {
      c = fgetc(F);
      Image[i] = c;
    }
  R.dX = (int)Image[0] + 256*(int)Image[1];
  R.dY = (int)Image[2] + 256*(int)Image[3];
  fclose(F);

  Check("AllImages::Read");
  return AllImages::AddItem(Fn,Image);
}

void AllImages::Draw(int N, TRect R)
{
  for(AI_Item *T=First; T!=NULL; T=T->Next)
    if (T->Number==N)
      {
	T->Draw(R);
	break;
      };
}

AllImages::~AllImages()
{
  Done();
}

void AllImages::Done()
{
  AI_Item
    *T = First,
    *TNext;
  while (T!=NULL)
    {
      TNext = T->Next;
      delete T;
      T = TNext;
    }
  Check("AllImages::Done");
}

//////////////////////////
//    class Image	//
//////////////////////////

class Image
{
 public:
  //int Number;
  int NImage;  // ࠦ
  Image *Next;
  Image(char*, TRect&);
  ~Image();
  void Draw(TRect, char=0);
  void HandleEvent(TEvent&);
};

Image::Image(char* Fn, TRect& R)
{
  NImage = AllImages::Read(Fn, R);
  Next = this;
}

Image::~Image()
{
  Check("Image::~Image1");
  AllImages::Delete(NImage);
  Check("Image::~Image2");
}

void Image::Draw(TRect R, char Active)
{
  R.P.X += Active;
  R.P.Y += Active;
  AllImages::Draw(NImage, R);
}

void Image::HandleEvent(TEvent&)
{
}

//////////////////////////
//    class Images	//
//////////////////////////

class Images
{
 public:
  int Count;
  Image *First;  //᪨ ᯨ᮪
  Images();
  Images(char*, TRect&);
  ~Images();
  void AddImage(char*, TRect&);
  void Draw(TRect, char);
  void HandleEvent(TEvent&);
};

Images::Images()
{
  First = NULL;
  Count = 0;
}

Images::Images(char* str, TRect& R)
{
  First = NULL;
  Count = 0;

  char Str[80];
  do
    {
      ReadWord(str,"\"",Str);
      AddImage(Str, R);
      DelChar(str,", \"");
    }
  while (str[0]!=0);
}

Images::~Images()
{
  Image
    *T = First,
    *TNext;
  for (int i=0; i<Count; i++)
    {
      TNext = T->Next;
      delete T;
      T = TNext;
    }
  Check("Images::~Images");
}

void Images::AddImage(char* Fn, TRect& R)
{
  Image *New = new Image(Fn,R);
  if (First==NULL)
    {
      First = New;
      First->Next = New;
    }
  else
    {
      Image *T = First;
      for (int i=1; i<Count; i++)
	T = T->Next;
      //  T - ᫥ 
      T->Next = New;
      New->Next = First;
      First = New;
      //New->Number = Count;
    }
  Count++;
}

void Images::Draw(TRect R, char Active)
{
  if (Count>1) Active = 0;
  First->Draw(R, Active);
}

void Images::HandleEvent(TEvent&)
{
}

//////////////////////////
//     class TEdit	//
//////////////////////////

class TEdit
{
 public:
  TRect R;
  char *Text;
  int Font;
  int Direction;
  int CharSize;
  int d;	//ࠢ  Y-न  outtextxy
  int Beg;	// ᨬ, 稭  ண ⮡ࠦ ⥪
  void Init();
  TEdit();
  TEdit(char*);
  ~TEdit();
  void Draw(TRect, char);
  void HandleEvent(TEvent&);
};

void TEdit::Init()
{
  Font = DEFAULT_FONT;
  Direction = HORIZ_DIR;
  CharSize = 0;
  Beg = 0;
  d = MAXINT;
}

TEdit::TEdit()
{
  Text = new char;
  Text[0] = 0;
  Init();
}

TEdit::TEdit(char *text)
{
  Init();
  Text = new char[strlen(text)+1];
  strcpy(Text, text);
}

TEdit::~TEdit()
{
  delete[] Text;
}

int CharWidth(char c)
{
  char ch[]="*";
  ch[0] = c;
  return textwidth(ch);
}

void OutCharXY(int x, int y, char c)
{
  char ch[]="*";
  ch[0] = c;
  outtextxy(x,y,ch);
}

void TEdit::Draw(TRect R, char Active=1)
{
  settextstyle(Font,Direction,CharSize);
  settextjustify(LEFT_TEXT,TOP_TEXT);

  int h = textheight(Copyright());
  if (d==MAXINT)
    {
      //塞 ࠢ
      R.Bar(EGA_WHITE);
      setcolor(EGA_BLACK);
      outtextxy(R.P.X, R.P.Y, ")");
      for (int y=R.P.Y, x;; y++)
	{
	  for (x=0; x<textwidth(")"); x++)
	    if ((d = getpixel(R.P.X+x,y))==EGA_BLACK) break;
	  if (d==EGA_BLACK)
	    {
	      d = y - R.P.Y;
	      break;
	    }
	}
    }
  R.Bar(EGA_WHITE);
  R.Button(Active);
  this->R = R;
  if (Text[0])
    {
      setcolor(EGA_BLACK);
      int
	cw = h,		//Current Width
	i = Beg;
      while (Text[i]!=0 && cw+CharWidth(Text[i])<=R.dX-h)
	{
	  OutCharXY(R.P.X+cw, R.P.Y + (R.dY-h)/2 - d, Text[i]);
	  cw += CharWidth(Text[i]);
	  i++;
	}
    }
}

void TEdit::HandleEvent(TEvent &Event)
{
  PointXY M = Event.Info.P;
  HideMouse();
  char
    fDraw = 1,
    fExit = 0;

  settextstyle(Font,Direction,CharSize);
  settextjustify(LEFT_TEXT,TOP_TEXT);

  int
    c,
    h    = textheight(Copyright()),
    cw   = h,		//Current Width
    CurI,
    CurX,		//Cursor - 
    End,
    i    = Beg;

  //  襩   樨 

  unsigned int Best_abs = 65535;
  while (Text[i-1]!=0 && cw<=R.dX-h)
    {
      if (abs(M.X-R.P.X-cw)<Best_abs)
	{
	  CurI = i;
	  Best_abs = abs(M.X-R.P.X-cw);
	  CurX = cw;
	}
      cw += CharWidth(Text[i++]);
    }

  End = i-1;
  CurX += R.P.X;

  do
    {
      // 㥬 
      setcolor(Text_Cursor_Color);
      setwritemode(XOR_PUT);
      line(CurX, R.P.Y + (R.dY-h)/4, CurX, R.P.Y + R.dY - (R.dY-h)/4);
      c = getch();
      // ࠥ 
      line(CurX, R.P.Y + (R.dY-h)/4, CurX, R.P.Y + R.dY - (R.dY-h)/4);
      setwritemode(COPY_PUT);

      fDraw = 0;
      switch (c)
	{
	  case 0:
	    switch (getch())
	      {
		case kbRight: //Right
		  if (CurI<End)
		    CurX+=CharWidth(Text[CurI++]);
		  else
		    if (Text[CurI])
		      {
			End++;
			CurI++;
			fDraw = 2;
		      }
		  break;
		case kbLeft: //Left
		  if (CurI>Beg)
		    CurX-=CharWidth(Text[--CurI]);
		  else
		    if (Beg)
		      {
			Beg--;
			CurI--;
			fDraw = 1;
		      }
		  break;
		case kbHome: //Home
		  Beg = 0;
		  CurI = 0;
		  fDraw = 1;
		  break;
		case kbEnd: //End
		  Beg = 0;
		  End = strlen(Text);
		  CurI = End;
		  if (textwidth(Text)<=R.dX-2*h)
		    fDraw = 1;
		  else
		    fDraw = 2;
		  break;
		case kbDel: //Delete
		  if (Text[0])
		    {
		      int j = 0;
		      char *New = new char[strlen(Text)];
		      for (i=0; Text[i]!=0; i++)
			if (i!=CurI)
			  New[j++] = Text[i];
		      New[j] = 0;
		      delete[] Text;
		      Text = New;
		      fDraw = 1;
		    }
		  break;
		case kbAltX: //Alt+X
		  Event.What = evCommand;
		  Event.Info.C = cmExit;
		  fExit = 1;
		  break;
		default:
		  break;
	      }
	    break;
	  case kbBack: //Backspace
	    if (CurI)
	      {
		CurI--;
		// Delete
		int j = 0;
		char *New = new char[strlen(Text)];
		for (i=0; Text[i]!=0; i++)
		  if (i!=CurI)
		    New[j++] = Text[i];
		New[j] = 0;
		delete[] Text;
		Text = New;
		fDraw = 1;
		//end of Delete
		if (CurI<Beg) Beg = CurI;
	      }
	    break;
	  case kbEsc: //ESC
	    fExit = 1;
	    fDraw = 1;
	    break;
	  case '`':
	    fExit = 0; // ⫠
	    break;
	  case kbEnter: //Enter
	    fExit = 1;
	    fDraw = 1;
	    break;
	  default:
	    if (c>=' ')
	      {// ⠢塞 ᨬ    CurI
		int j = 0;
		char *New = new char[strlen(Text)+2];
		for (i=0; Text[i-1]!=0; i++)
		  if (i==CurI)
		    New[i] = c;
		  else
		    New[i] = Text[j++];
		New[i] = 0;
		delete[] Text;
		Text = New;
		fDraw = 1;
		//Right
		if (CurI<End)
		  CurI++;
		else
		  if (Text[CurI])
		    {
		      End++;
		      CurI++;
		      if (textwidth(Text)<=R.dX-2*h)
			fDraw = 1;
		      else
			fDraw = 2;
		    }
	      }
	    break;
	}
      if (fDraw)
	{
	  R.Bar(EGA_WHITE);
	  R.Button(1);
	  setcolor(EGA_BLACK);
	}
      if (fDraw==1)
	{
	  cw = h;
	  CurX = MAXINT;
	  i = Beg;
	  while (Text[i]!=0 && cw+CharWidth(Text[i])<=R.dX-h)
	    {
	      if (i==CurI) CurX = cw;
	      OutCharXY(R.P.X+cw, R.P.Y + (R.dY-h)/2 - d, Text[i]);
	      cw += CharWidth(Text[i++]);
	    }
	  if (CurX==MAXINT) CurX = cw;
	  End = i; //?
	  CurX += R.P.X;
	}
      else
      if (fDraw==2)
	{
	  CurX = MAXINT;
	  i = End-1;
	  cw = R.dX - h;
	  while (i && cw-CharWidth(Text[i])>=h)
	    {
	      cw -= CharWidth(Text[i]);
	      OutCharXY(R.P.X+cw, R.P.Y + (R.dY-h)/2 - d, Text[i]);
	      if (--i==CurI) CurX = cw;
	    }
	  if (CurX==MAXINT) CurX = R.dX - h;
	  Beg = i+1;
	  CurX += R.P.X;
	}
    }
  while (!fExit);
  InputLine = Text;
  SetMouseCoo(CurX, M.Y);
  ShowMouse();
}

//////////////////////////
//    class TLine	//
//////////////////////////

class TLine
{
 public:
  TLine();
  TLine(char*);
  void Draw(TRect, char);
};

TLine::TLine()
{
}

void TLine::Draw(TRect R, char /*Active=1*/)
{
  setcolor(EGA_DARKGRAY);
  line(R.P.X, R.P.Y, R.P.X+R.dX, R.P.Y+R.dY);
  setcolor(EGA_WHITE);
  if (R.dY==0)
    line(R.P.X, R.P.Y+1, R.P.X+R.dX, R.P.Y+R.dY+1);
  else
    line(R.P.X+1, R.P.Y, R.P.X+R.dX+1, R.P.Y+R.dY);
}

TLine::TLine(char* /*str*/)
{
}

//////////////////////////
//    class WItem	//
//////////////////////////

typedef enum
{
  Nothink,
  Text,	// 
  Icon,	// 
  Edit,	//  ।஢
  Line	// 
} WItemType;

class WItem
{
 public:
  TRect R;
  WItemType Type;
  int Command;
  union
    {
      TText *Text;
      Images *Icon;
      TEdit *Edit;
      TLine *Line;
    } Info;
  WItem *Next;
  WItem();
  ~WItem();
  WItem(WItemType, char *, PointXY);
  void Draw(char);
  void HandleEvent(TEvent&);
};

WItem::WItem()
{
  Type = Nothink;
  Next = NULL;
  Command = 0;
}

WItem::~WItem()
{
  Check("WItem::~WItem");
  switch (Type)
    {
      case Text:
	delete Info.Text;
	break;
      case Icon:
	delete Info.Icon;
	break;
      case Edit:
	delete Info.Edit;
	break;
      case Line:
	delete Info.Line;
	break;
    }
}

WItem::WItem(WItemType type, char *str, PointXY dP)
{
  Type = type;
  char Z[]=", ";
  char Str[80];
  ReadWord(str, Z, R.P.X);
  ReadWord(str, Z, R.P.Y);
  R.P = R.P+dP;
  if (Type!=Icon)
    {
      ReadWord(str, Z, R.dX);
      ReadWord(str, Z, R.dY);
    }
  switch (Type)
    {
      case Text:
	Info.Text = new TText(str);
	break;
      case Icon:
	DelChar(str,", \"");
	Info.Icon = new Images(str,R);
	break;
      case Edit:
	DelChar(str,", \"");
	ReadWord(str,"\"",Str);
	Info.Edit = new TEdit(Str);
	break;
      case Line:
	R.dX = R.dX-R.P.X+dP.X;
	R.dY = R.dY-R.P.Y+dP.Y;
	Info.Line = new TLine(str);
	break;
    }
}

void WItem::Draw(char fMouse=0)
{
  if ((Type!=Icon && Command)
      || (Type==Icon && Info.Icon->Count<2 && Command))
    R.Button(fMouse);
  switch (Type)
    {
      case Text:
	Info.Text->Draw(R, fMouse);
	break;
      case Icon:
	Info.Icon->Draw(R, fMouse);
	break;
      case Edit:
	Info.Edit->Draw(R, 1);
	break;
      case Line:
	Info.Line->Draw(R, 1);
	break;
    }
}

void WItem::HandleEvent(TEvent &Event)
{
  switch (Type)
    {
      case Edit:
	if (Event.What==evLeftPressed)
	  Info.Edit->HandleEvent(Event);
	break;
      case Icon:
	if (Event.What==evLeftReleace)
	  if (Info.Icon->Count>1)
	    {
	      Info.Icon->First = Info.Icon->First->Next;
	      HideMouse();
	      Draw();
	      ShowMouse();
	    }
	break;
      case Text:
	break;
      case Line:
	error("WItem::HandleEvent Line");
	break;
    }
  if (Event.What==evLeftReleace)
    {
      Event.What = evCommand;
      Event.Info.C = Command;
    }
}

//////////////////////////
//    class TWindow	//
//////////////////////////

class TWindow
{
 public:
  int Number;
  TRect R;
  int Count;	   // - ⨢ ⮢
  WItem *A_First;  // ⨢   (横᪨ ᯨ᮪)
  WItem *P_First;  // ᨢ  
  char fMouse;	   // 室     A_First
  TWindow *Next;
  TWindow();
  ~TWindow();
  void Draw();
  void AddItem(WItemType, char*);
  void HandleEvent(TEvent&);
  void MoveTo(PointXY);
};

TWindow::TWindow()
{
  A_First = NULL;
  P_First = NULL;
  Next = NULL;
  Count = 0;
}

TWindow::~TWindow()
{
  WItem* TNext;
  for (WItem *T = P_First; T != NULL; T = TNext)
    {
      TNext = T->Next;
      delete T;
    }

  T = A_First;
  for (int i=0; i<Count; i++)
    {
      TNext = T->Next;
      delete T;
      T = TNext;
    }
}

void TWindow::Draw()
{
  WItem *T;
  R.Bar(EGA_LIGHTGRAY);
  R.Border();
  // ᮢ ᨢ ⮢
  for (T = P_First; T != NULL; T = T->Next)
      T->Draw();
  // ᮢ ⨢ ⮢
  T = A_First;
  for (int i=0; i<Count; i++)
    {
      T->Draw();
      T = T->Next;
    }
}

void TWindow::AddItem(WItemType type, char *str)
{
  char command[80];
  ReadWord(str,", ",command);
  WItem *NewItem = new WItem(type, str, R.P);
  if (type==Line)
    NewItem->Command = 0; //    ⨢
  else
    NewItem->Command = atoi(command);

  if (NewItem->Command)
    {
      WItem *T = NewItem;
      NewItem->Next = A_First;
      for (int i=0; i<Count; i++)
	T=T->Next;
      // T - ᫥ 
      A_First = NewItem;
      T->Next = NewItem;
      Count++;
    }
  else
    {
      NewItem->Next = P_First;
      P_First = NewItem;
    }
  Check("TWindow::AddItem");
}

void TWindow::HandleEvent(TEvent &Event)
{
  if (A_First!=NULL)
    {
      if (R.In(Event.Info.P))
	//    
	if (fMouse)
	  if (A_First->R.In(Event.Info.P))
	  //  ⠫  ⮬  
	    A_First->HandleEvent(Event);
	  else
	    fMouse = 2;
	else;
      else
	if (fMouse) fMouse++;
      if (fMouse==2)
	{
	  fMouse = 0;
	  if (A_First->Type!=Edit)
	    {
	      HideMouse();
	      A_First->Draw(fMouse);
	      ShowMouse();
	    }
	}
      if (!fMouse)
	{
	  // ..   
	  WItem *T = A_First;
	  for (int i=0; i<Count; i++, T=T->Next)
	    if (T->R.In(Event.Info.P))
	      {
		fMouse = 1;
		A_First = T;
		if (T->Type!=Edit)
		  {
		    HideMouse();
		    T->Draw(fMouse);
		    ShowMouse();
		  }
		break;
	      };
	}
    }
}

void TWindow::MoveTo(PointXY p)
{
  for (WItem *T = P_First; T != NULL; T = T->Next)
    {
      T->R.P.X = T->R.P.X - R.P.X + p.X;
      T->R.P.Y = T->R.P.Y - R.P.Y + p.Y;
    }

  T = A_First;
  for (int i=0; i<Count; i++)
    {
      T->R.P.X = T->R.P.X - R.P.X + p.X;
      T->R.P.Y = T->R.P.Y - R.P.Y + p.Y;
      T = T->Next;
    }
  R.P = p;
}

//////////////////////////
//    class TWindows	//
//////////////////////////

class TWindows
{
 public:
  TRect R;
  TWindow *First;	// 
  TWindow *Last;	//孥 
  int NextW;		// ᫥饣   䠩 F
  char fMove;		//ந室  ६饭  (ࠢ  )
  TRect M;		//  (Move)
  FILE *F;
  TWindows();
  ~TWindows();
  void Draw();
  void Read(int);
  void AddItem(TWindow*);
  void HandleEvent(TEvent&);
  void Delete(int);
  void ToWindow(int);
};

TWindows::TWindows()
{
  if ((F = fopen(FWins, "rt")) == NULL) error(3,FWins);
  First = NULL;
  Last = NULL;
  NextW = MAXINT;
  R.Assign(0,0,getmaxx(),getmaxy());
  SetMouseWindow(R.P.X, R.P.Y, R.P.X+R.dX, R.P.Y+R.dY);
  fMove = 0;
}

TWindows::~TWindows()
{
  TWindow *TNext;
  for (TWindow *T=First; T!=NULL; T=TNext)
    {
      TNext = T->Next;
      delete T;
    }
}

void TWindows::Draw()
{
  HideMouse();
  cleardevice();  //R.Bar(EGA_BLACK);

  for (TWindow *T = First; T!=NULL; T=T->Next)
    T->Draw();

  ShowMouse();
}

int WCNumber(char *Str)
{
  UpCase(Str);
  for (unsigned int i=0; i<WCCount; i++)
    if (strcmp(Str,WC[i])==0)
      return i; //Ok
  return WCCount;
}

// ⥭ ப  䠩
char FReadStr(FILE* F, char* str, unsigned int max_len=80)
{
  char c='*';
  for (unsigned int i = 0; !feof(F) && i<max_len && c!='\n'; i++)
  {
    c = fgetc(F);
    str[i] = c;
  }
  if (feof(F) || c=='\n')
    {
      str[i-1] = 0;
      return 0; //Ok
    }
  else
    return 1;
}

void TWindows::Read(int N)
//⥭   䠩   ᮢ
{
  char
    flag=0;  //    ஬ N
  if (NextW==N) flag = 1;
  else
    if (N < NextW)
      {
	fseek(F,0,SEEK_SET);  // 砫 䠩
	NextW = MAXINT;
      }
  char str[80],word[80]; // 0..79
  TWindow *NewW = new TWindow;
  NewW->Number = N;
  HideMouse();
  while (!feof(F))
    {
      if (FReadStr(F,str,80)) error(8,FWins);
      if (str[0]!=0)
      if (In('[',str))
	{
	  //  
	  DelChar(str,'[');
	  DelChar(str,']');
	  NextW = atoi(str);
	  if (NextW==N)
	    flag = 1;
	  else
	    if (NextW > N) break;
	  }
      else
	if (flag)
	  {
	    ReadWord(str,"= ",word);
	    DelChar(str,"= ");
	    switch (WCNumber(word))
	      {
		case 0: // ਩
		  break;
		case Text:
		  NewW->AddItem(Text,str);
		  break;
		case Icon:
		  NewW->AddItem(Icon,str);
		  break;
		case Edit:
		  NewW->AddItem(Edit,str);
		  break;
		case Line:
		  NewW->AddItem(Line,str);
		  break;
		case 5: //X
		  NewW->R.P.X+=atoi(str);
		  break;
		case 6: //Y
		  NewW->R.P.Y+=atoi(str);
		  break;
		case 7: //dX
		  NewW->R.dX = atoi(str);
		  break;
		case 8: //dY
		  NewW->R.dY = atoi(str);
		  break;
		default:
		  error(9,word);
	      }
	  }
    }
  if (flag)
    {
      AddItem(NewW);
      if (feof(F))
	NextW=MAXINT;
    }
  else
    {
      delete NewW;
      gcvt(N,10,str);
      error(10,str);
    }
  ShowMouse();
}

void TWindows::AddItem(TWindow *Item)
{
  Item->Next = NULL;
  Last->Next = Item;
  Last = Item;
  if (First==NULL) First = Item;
  Check("TWindows::AddItem");
}

void TWindows::Delete(int n)
{
  TWindow
    _T,
    *T = &_T,
    *H = NULL;
  T->Next = First;
  while (T->Next!=NULL)
    {
      if (T->Next->Number==n)
	H = T;
      T = T->Next;
    }
  if (H!=NULL)
    {
      T = H->Next;
      H->Next = T->Next;
      if (T==Last) Last = H;
      if (T==First) First = H;
      delete T;
    }
  Check("TWindows::Delete");
}

void TWindows::HandleEvent(TEvent &Event)
{
  if (First==NULL) return;
  Command com;
  if (fMove)
    {
      if (Event.What==evRightPressed)
	{
	  if (M.P!=Event.Info.P)
	    {
	      TRect H;
	      H = Last->R;

	      H.P.X = M.P.X + M.dX;
	      H.P.Y = M.P.Y + M.dY;

	      if (!fSpeed) H.Rectangle(Window_Move_Color); //૨ 

	      H.P.X = Event.Info.P.X + M.dX;
	      H.P.Y = Event.Info.P.Y + M.dY;
	      if (fSpeed)
		{
		  Last->MoveTo(H.P);
		  Draw();
		}
	      else
		H.Rectangle(Window_Move_Color); //㥬 
	      M.P = Event.Info.P;
	    }
	}
      else
	{ // 
	  TRect H;
	  H = Last->R;

	  H.P.X = M.P.X + M.dX;
	  H.P.Y = M.P.Y + M.dY;
	  if (!fSpeed)
	    {
	      H.Rectangle(Window_Move_Color); //૨ 
	      setlinestyle(SOLID_LINE,0,NORM_WIDTH); //1111
	      setwritemode(COPY_PUT);
	    }
	  fMove = 0;
	  H.P.X = Event.Info.P.X + M.dX;
	  H.P.Y = Event.Info.P.Y + M.dY;
	  if (H.P!=Last->R.P)
	    {
	      //Last->R.Bar(BLACK);
	      Last->MoveTo(H.P);
	      Draw();
	    }
	  SetMouseWindow(R.P.X, R.P.Y, R.P.X+R.dX, R.P.Y+R.dY);
	  ShowMouse();
	}
    }
  else //!fMove
  if (Last->R.In(Event.Info.P))
    {
      if (Event.What==evRightPressed)
	{
	  M.P = Event.Info.P;
	  M.dX = Last->R.P.X - Event.Info.P.X;
	  M.dY = Last->R.P.Y - Event.Info.P.Y;
	  SetMouseWindow(R.P.X-M.dX, R.P.Y-M.dY,
	   R.P.X+R.dX-Last->R.dX-M.dX, R.P.Y+R.dY-Last->R.dY-M.dY);
	  fMove = 1;
	  HideMouse();
	  if (!fSpeed)
	    {
	      setlinestyle(USERBIT_LINE,0x3333,NORM_WIDTH);
	      //0011|0011|0011|0011
	      setwritemode(XOR_PUT);
	      Last->R.Rectangle(Window_Move_Color);
	    }
	}
      else //  ࠢ  
	Last->HandleEvent(Event);
    }
  else //諨  ⥪饣 
    {
      Last->HandleEvent(Event);
      if (Event.What==evLeftPressed || Event.What==evRightPressed
      || Event.What==evLeftReleace)
	{
	  TWindow
	    T_,
	    *T = &T_,
	    *H = NULL;
	  T->Next = First;
	  Check("TWindows::HandleEvent");
	  while (T->Next!=NULL)
	    {
	      if (T->Next->R.In(Event.Info.P))
		H = T;
	      T=T->Next;
	    }
	  if (H!=NULL)
	    {
	      T = H->Next;
	      if (T==First) First=T->Next;
	      H->Next = T->Next;
	      Last->Next = T;
	      Last = T;
	      Last->Next = NULL;
	      HideMouse();
	      Last->Draw();
	      ShowMouse();
	    }
	}
    }
  Check("TWindows::HandleEvent");
}

void TWindows::ToWindow(int)
{
  for (TWindow *T = First; T!=NULL; T=T->Next);
//    if ()
}

//////////////////////////
//  class TApplication	//
//////////////////////////

class Application
{
  char Type;
  char fw2;
  char fw3;	// ⢨  3 //flag window 3
  char fw4;
  char fw5;
  char fw6;
  char fw7;
  char fgr;	//࠭
  char grcount;
  int PictN;	//騩  ࠦ
  int VESAMode;
  double Alfa;  // ࠤ
 public:
  TWindows* Wins;
  TKeys Keys;
  PointLight L;
  Application();
  void Run();
  void Done();
  void Type1();
  void Type2();
  void Type3();
  void Type4();
  Camera UserCamera(double,double);
  void SetWaterColor(Color=Color_Water);
  void SetGlassColor(Color=Color_Glass);
  void Show(Scene&);
  ~Application();
  void ExecuteCommand(TEvent&);
};

void MemoryHandler()
{
  error(4);
}

int CtrlBreakHandler()
{
  HideMouse();
  closegraph();
  Check("Done");
  cout<<Copyright()<<endl;
  exit(0);
  return 0;
}

Application::Application(): L(Point(100,150,-100),White)
{
  if (!IsMouse()) error(15);

  FILE* F;
  if ((F=fopen(PictDat,"rb"))==NULL) PictN = 0;
  else
    {
      fread(&PictN,sizeof(PictN),1,F);
      fclose(F);
    }

  VESA V;
  if (!V.Is()) error(14);
  VESAInfo VI;
  V.GetInfo(VI);
  if (VI.Version<258) error(16);
  if (VI.VideoMemory<16) error(17);
  if (!V.IsMode(VESAMode = VESA_640x480x32))
    if (!V.IsMode(VESAMode = VESA_640x480x24))
      if (!V.IsMode(VESAMode = VESA_640x480x16))
	if (!V.IsMode(VESAMode = VESA_640x480x15))
	  error(7);

  GrInit();
  SetWaterColor();
  SetGlassColor();
  ShowMouse();
  Wins = new TWindows;
  Keys.Add(cmExit,kbEsc);
  Keys.Add(cmPos,kbDiv);
  Keys.Add(cmMemSize,kbMul);
  fw2 = 1;
  fw3 = 1;
  fw4 = 1;
  fw5 = 1;
  fw6 = 1;
  fw7 = 1;
  Type = 3;
  fgr = 0;
  grcount = 10;
  Alfa = atan2(1,5);
}

void Application::Done()
{
  delete Wins;
  AllImages::Done();
  HideMouse();
  closegraph();
  Check("Done");
  cout<<Copyright()<<endl;
}

Application::~Application()
{
  Done();
}

void Application::Run()
{
  TEvent Event;
  Wins->Read(1);
  Wins->Draw();
  char
    fExit = 0,
    fLeftPressed = 0,
    fRightPressed = 0;
  int X,Y,oX=0,oY=0,mk=0;
  do
    {
      Event.Clear();

      if (kbhit())
	{
	  Event.What = evKeyPressed;
	  Event.Info.K.Code = getch();
	  if (Event.Info.K.Code==0)
	    Event.Info.K.ExtCode = getch();
	}
      Keys.HandleEvent(Event);

      GetMouseCoo(X,Y,mk);
      Event.Info.P.X = X;
      Event.Info.P.Y = Y;
      if (X!=oX || Y!=oY)
	{
	  if (Event.What < evMove)
	    Event.What = evMove;
	  oX = X;
	  oY = Y;
	}
      if (mk&1)
	{
	  //⨥   
	  if (Event.What <= evMove)
	    Event.What = evLeftPressed;
	  fLeftPressed=1;
	}
      else
	if (fLeftPressed)
	  {
	    //᪠   
	    if (Event.What <= evMove)
	      Event.What = evLeftReleace;
	    fLeftPressed=0;
	  }
      if (mk&2)
	{
	  //⨥ ࠢ  
	  if (Event.What <= evMove)
	    Event.What = evRightPressed;
	  fRightPressed=1;
	}
      else
	if (fRightPressed)
	  {
	    //᪠ ࠢ  
	    if (Event.What <= evMove)
	      Event.What = evRightReleace;
	    fRightPressed=0;
	  }

      if (Event.What==evRightReleace &&
	  Event.Info.P.X==0 && Event.Info.P.Y==0)
	{
	  Event.What = evCommand;
	  Event.Info.C = cmExit;
	}
      else
	Wins->HandleEvent(Event);

      if (Event.What==evCommand)
	ExecuteCommand(Event);

      if (Event.What==evCommand && Event.Info.C==cmExit)
	fExit = 1;
      //NearHeapSize();
    }
  while (!fExit);
}


void Application::Show(Scene& S)
{
  if (S.Lights!=NULL && S.Objects!=NULL)
    {
      char FN[]="PICT\\pict0000.tga";
      sprintf(FN+9,"%04.4u",PictN);
      FN[13]='.';

      FILE* F;
      if ((F=fopen(FN,"wb"))==NULL)
	mkdir("PICT");
      else
	fclose(F);

      Targa TGA(FN,X_MAX-X_MIN,Y_MAX-Y_MIN);

      VESA V;
      int mode = getgraphmode();
      V.SetMode(VESAMode);

      FN[14]='d';FN[15]='a';FN[16]='t';

      if ((F = fopen(FN,"wt"))==NULL) error(18,FN);

      fprintf(F,"ࠬ ⥪\n");
      fprintf(F,"  Eta  = %g\n",m_Glass.Eta);
      fprintf(F,"  Kabs = %g\n",m_Glass.Kabs);
      fprintf(F,"  Ka   = %g\n",Surf_Glass.Ka);
      fprintf(F,"  Kd   = %g\n",Surf_Glass.Kd);
      fprintf(F,"  Ks   = %g\n",Surf_Glass.Ks);
      fprintf(F,"  Kt   = %g\n",Surf_Glass.Kt);
      fprintf(F,"  p    = %g\n",Surf_Glass.p);
      fprintf(F,"  R    = %g\n",Color_Glass.R);
      fprintf(F,"  G    = %g\n",Color_Glass.G);
      fprintf(F,"  B    = %g\n",Color_Glass.B);
      fprintf(F,"\nࠬ \n");
      fprintf(F,"  Eta  = %g\n",m_Water.Eta);
      fprintf(F,"  Kabs = %g\n",m_Water.Kabs);
      fprintf(F,"  Ka   = %g\n",Surf_Water.Ka);
      fprintf(F,"  Kd   = %g\n",Surf_Water.Kd);
      fprintf(F,"  Ks   = %g\n",Surf_Water.Ks);
      fprintf(F,"  Kt   = %g\n",Surf_Water.Kt);
      fprintf(F,"  p    = %g\n",Surf_Water.p);
      fprintf(F,"  R    = %g\n",Color_Water.R);
      fprintf(F,"  G    = %g\n",Color_Water.G);
      fprintf(F,"  B    = %g\n",Color_Water.B);
      fprintf(F,"\n\n");
      fprintf(F,"  Alfa = %g\n",Alfa*180/M_PI);
      fprintf(F,"\n筨 ᢥ\n");
      fprintf(F,"  X = %g\n",L.C.X);
      fprintf(F,"  Y = %g\n",L.C.Y);
      fprintf(F,"  Z = %g\n",L.C.Z);
      fprintf(F,"  I = %g\n",L.I.R);

      clock_t Time = clock();
      char fComplete = S.Show(X_MIN,Y_MIN,X_MAX,Y_MAX,&V,&TGA);
      Time = clock() - Time;

      fprintf(F,"\n६ ᨭ⥧ = %g ᥪ㭤\n",Time/CLK_TCK);
      fclose(F);

      if (fComplete)
      {
	if ((F = fopen(PictDat,"wb"))==NULL) error(18,PictDat);
	if (PictN==9999)
	  PictN = 0;
	else
	  PictN++;
	fwrite(&PictN,sizeof(PictN),1,F);
	fclose(F);
	sound(800);
	delay(100);
	nosound();
      }

      if (getch()==0) getch();
      setgraphmode(mode);
    }
}

Camera Application::UserCamera(double h, double d)
{
  Point
    P1(0,h/2,0),
    P2(0,h/2+d*sin(Alfa),-d*cos(Alfa));
  return Camera(P2,Vector(P2,P1),Vector(0,1,0));
}

// ⠪
void Application::Type1()
{
  const double
    h = 150,
    r = 60,
    r1 = 40,
    h2 = 10,
    h3 = (h+h2)/2,
    dr = 5,
    k = (r-r1)/h,
    r2 = r-dr - (h-h2)*k,
    r3 = r-dr - (h-h3)*k;

  Scene* S = new Scene;

  Cone* Con1 = new Cone(h,r,0,r1);
  Con1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Cone* Con2 = new Cone(h2,r2,h3,r3);
  Con2->Eigenschaft(Color_Water,Glass,Water,Surf_Water);

  Cone* Con3 = new Cone(h3,r3,h,r-dr);
  Con3->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir1 = new Circle(Point(0,0,0),Vector(0,1,0),r1);
  Cir1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir2 = new Circle(Point(0,h2,0),Vector(0,1,0),r2);
  Cir2->Eigenschaft(Color_Water,Glass,Water,Surf_Water);

  Circle* Cir3 = new Circle(Point(0,h3,0),Vector(0,1,0),r3);
  Cir3->Eigenschaft(Color_Water,Vacuum,Water,Surf_Water);

  Ring* R1 = new Ring(Point(0,h,0),Vector(0,1,0),r,r-dr);
  R1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  *S<<UserCamera(h,h);

  Show(*S<<&L<<Con1<<Con2<<Con3<<Cir1<<Cir2<<Cir3<<R1);

  delete R1;

  delete Cir3;
  delete Cir2;
  delete Cir1;

  delete Con3;
  delete Con2;
  delete Con1;

  delete S;
}

// ࠡ᪠ 
void Application::Type2()
{
  const double
    h = 200,
    h2 = h/2,
    h1 = h/12,
    dr = 5,
    h3 = h2 + dr,
    r = 70,
    r2 = 5,
    r1 = 40,
    k = sqr(r-dr)/(h-h3),
    h4 = (h + h3)/2,
    r4 = sqrt(k*(h4-h3));

  Scene* S = new Scene;

  Paraboloid* Par1 = new Paraboloid(h2,r2,h,r); //  \/
  Par1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Paraboloid* Par2 = new Paraboloid(h3,0,h4,r4); //  \/
  Par2->Eigenschaft(Color_Water,Water,Glass,Surf_Water);

  Paraboloid* Par3 = new Paraboloid(h,r-dr,h4,r4); //  \ /
  Par3->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Cylinder* Cyl1 = new Cylinder(r2,h1,h2); //  ||
  Cyl1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Cone* Con1 = new Cone(0,r1,h1,r2); //  /\
  Con1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir1 = new Circle(Point(0,h4,0),Vector(0,1,0),r4);
  Cir1->Eigenschaft(Color_Water,Vacuum,Water,Surf_Water);

  Circle* Cir2 = new Circle(Point(0,0,0),Vector(0,1,0),r1);
  Cir2->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  /*Plane* Pl = new Plane(Point(0,0,0),Vector(0,1,0));
  Pl->Eigenschaft(Color(1,1,1),Vacuum,Glass,
    SurfaceProperty( 1, 0.2, 0.5, 0.8, 10));*/

  Ring* R1 = new Ring(Point(0,h,0),Vector(0,1,0),r,r-dr);
  R1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  *S<<UserCamera(h,h);

  Show(*S<<&L<<Par1<<Par2<<Par3<<Cyl1<<Con1<<Cir1<<Cir2<<R1);

  delete R1;
  delete Cir2;
  delete Cir1;
  delete Con1;
  delete Cyl1;
  delete Par3;
  delete Par2;
  delete Par1;

  delete S;
}

// ᪠ 
void Application::Type3()
{
  const double
    h = 200,
    h2 = h/3,
    h1 = h/12,
    r = 50,
    r2 = 5,
    dr = 5,
    r1 = 40,
    k = (r-r2)/(h-h2),
    h3 = h - (r-dr)/k,
    h4 = (h+h3)/2,
    r4 = (h4-h3)*k;

  Scene* S = new Scene;

  Cone* Con1 = new Cone(h1,r2,0,r1); //  /\
  Con1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Cone* Con2 = new Cone(h2,r2,h,r); //  \ /
  Con2->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Cone* Con3 = new Cone(h3,0,h4,r4); //  \/
  Con3->Eigenschaft(Color_Water,Glass,Water,Surf_Water);

  Cone* Con4 = new Cone(h,r-dr,h4,r4); //  \ /
  Con4->Eigenschaft(Color_Glass,Glass,Vacuum,Surf_Glass);

  Cylinder* Cyl1 = new Cylinder(r2,h1,h2); //  ||
  Cyl1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir2 = new Circle(Point(0,h4,0),Vector(0,1,0),r4);
  Cir2->Eigenschaft(Color_Water,Vacuum,Water,Surf_Water);

  Ring* R1 = new Ring(Point(0,h,0),Vector(0,1,0),r,r-dr);
  R1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  *S<<UserCamera(h,20*h);

  Show(*S<<&L<<Con1<<Con2<<Con3<<Con4<<Cyl1<<Cir2<<R1);

  delete R1;
  delete Cir2;
  delete Cyl1;
  delete Con4;
  delete Con3;
  delete Con2;
  delete Con1;

  delete S;
}

// ࠭ ⠪
void Application::Type4()
{
  const double
    dalfa2 = M_PI/grcount,
    dalfa = 2*dalfa2,
    h = 150,
    r = 60,
    r1 = 40,
    h2 = 10,
    h3 = (h+h2)/2,
    dr = 5,
    k = (r-r1)/h,
    r2 = (r - (h-h2)*k)*cos(dalfa2) - dr,
    r3 = (r - (h-h3)*k)*cos(dalfa2) - dr;

  Scene* S = new Scene;

  Cone* Con1 = new Cone(h2,r2,h3,r3);
  Con1->Eigenschaft(Color_Water,Glass,Water,Surf_Water);

  Cone* Con2 = new Cone(h3,r3,h,r-dr);
  Con2->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir1 = new Circle(Point(0,0,0),Vector(0,1,0),r1);
  Cir1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  Circle* Cir2 = new Circle(Point(0,h2,0),Vector(0,1,0),r2);
  Cir2->Eigenschaft(Color_Water,Glass,Water,Surf_Water);

  Circle* Cir3 = new Circle(Point(0,h3,0),Vector(0,1,0),r3);
  Cir3->Eigenschaft(Color_Water,Vacuum,Water,Surf_Water);

  //Ring* R1 = new Ring(Point(0,h,0),Vector(0,1,0),r,r-dr);
  //R1->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);

  double alfa = 0;

  Rectangle* Rect;
  for (char i=0; i<grcount; i++,alfa+=dalfa)
    {
      Rect = new Rectangle(
	Point(r1*cos(alfa),0,r1*sin(alfa)),
	Point(r1*cos(alfa+dalfa),0,r1*sin(alfa+dalfa)),
	Point(r*cos(alfa),h,r*sin(alfa)),
	Point(r*cos(alfa+dalfa),h,r*sin(alfa+dalfa)));
      Rect->Eigenschaft(Color_Glass,Vacuum,Glass,Surf_Glass);
      *S<<Rect;
    }

  *S<<UserCamera(h,h);

  Show(*S<<&L<<Con1<<Con2<<Cir1<<Cir2<<Cir3);

  //delete R1;

  delete Cir3;
  delete Cir2;
  delete Cir1;

  delete Con2;
  delete Con1;

  delete S;
}

void Application::SetWaterColor(Color C)
{
  Color_Water = C;
  //setrgbpalette(EGA_LIGHTGREEN, C.R*255, C.G*255, C.B*255);
}

void Application::SetGlassColor(Color C)
{
  Color_Glass = C;
  //setrgbpalette(EGA_LIGHTBLUE, C.R*255, C.G*255, C.B*255);
}

void Application::ExecuteCommand(TEvent &Event)
{
  if (Event.What==evCommand)
    switch (Event.Info.C)
      {
	case 11:
	  if (Type==1)
	    Type=3;
	  else
	    Type--;
	  break;
	case 12:
	  if (fw2)
	    {
	      Wins->Read(2);
	      fw2 = 0;
	      Wins->Draw();
	    }
	  break;
	case 13:
	  if (fw5 && fw3)
	    {
	      Wins->Read(5);
	      fw5 = 0;
	      Wins->Draw();
	    }
	  break;
	case 14:
	  fgr = 1 - fgr;
	  break;
	case 15:
	  grcount = atof(InputLine);
	  break;
	case 16:
	  HideMouse();
	  switch (Type)
	    {
	      case 1:
		if (fgr)
		  Type4();
		else
		  Type1();
		break;
	      case 2:
		Type2();
		break;
	      case 3:
		Type3();
		break;
	    }
	  Wins->Draw();
	  ShowMouse();
	  break;
	case 17:
	  Event.Info.C = cmExit;
	  break;
	case 18:
	  if (fw6)
	    {
	      Wins->Read(6);
	      fw6 = 0;
	      Wins->Draw();
	    }
	  break;
	case 19:
	  if (fw7)
	    {
	      Wins->Read(7);
	      fw7 = 0;
	      Wins->Draw();
	    }
	  break;
	case 20:
	  Wins->Delete(2);
	  fw2 = 1;
	  Wins->Draw();
	  break;
	case 21:
	  m_Glass.Eta = atof(InputLine);
	  break;
	case 22:
	  m_Glass.Kabs = atof(InputLine);
	  break;
	case 23:
	  Surf_Glass.Ka = atof(InputLine);
	  break;
	case 24:
	  Surf_Glass.Kd = atof(InputLine);
	  break;
	case 25:
	  Surf_Glass.Ks = atof(InputLine);
	  break;
	case 26:
	  Surf_Glass.Kt = atof(InputLine);
	  break;
	case 27:
	  Surf_Glass.p = atof(InputLine);
	  break;
	case 28:
	  Color_Glass.R = atof(InputLine);
	  SetGlassColor();
	  break;
	case 29:
	  Color_Glass.G = atof(InputLine);
	  SetGlassColor();
	  break;
	case 210:
	  Color_Glass.B = atof(InputLine);
	  SetGlassColor();
	  break;
	case 30:
	  Wins->Delete(3);
	  fw3 = 1;
	  Wins->Draw();
	  break;
	case 31:
	  m_Water.Eta = atof(InputLine);
	  break;
	case 32:
	  m_Water.Kabs = atof(InputLine);
	  break;
	case 33:
	  Surf_Water.Ka = atof(InputLine);
	  break;
	case 34:
	  Surf_Water.Kd = atof(InputLine);
	  break;
	case 35:
	  Surf_Water.Ks = atof(InputLine);
	  break;
	case 36:
	  Surf_Water.Kt = atof(InputLine);
	  break;
	case 37:
	  Surf_Water.p = atof(InputLine);
	  break;
	case 38:
	  Color_Water.R = atof(InputLine);
	  SetWaterColor();
	  break;
	case 39:
	  Color_Water.G = atof(InputLine);
	  SetWaterColor();
	  break;
	case 310:
	  Color_Water.B = atof(InputLine);
	  SetWaterColor();
	  break;
	case cmPos:
	  cout<<"N = "<<Wins->Last->Number;
	  cout<<", X = "<<Wins->Last->R.P.X;
	  cout<<", Y = "<<Wins->Last->R.P.Y<<endl;
	  break;
	case cmMemSize:
	  NearHeapSize();
	  break;
	case 101:
	  if (fw4)
	    {
	      Wins->Read(4);
	      fw4 = 0;
	      Wins->Draw();
	    }
	  break;
	case 40:
	  Wins->Delete(4);
	  fw4 = 1;
	  Wins->Draw();
	  break;
	case 50:
	  Wins->Delete(5);
	  fw5 = 1;
	  Wins->Draw();
	  break;
	case 51: // 
	  //                           Ka  Kd  Ks  Kt  p
	  Surf_Water = SurfaceProperty( 0, 0, 0.5, 1, 10);
	  m_Water = Material(1.36, 0);
	  SetWaterColor(Color(0,0,0));
	  Wins->Delete(5);
	  fw5 = 1;
	  Wins->Draw();
	  break;
	case 52: // ᭮ 
	  //                           Ka   Kd   Ks   Kt   p
	  Surf_Water = SurfaceProperty( 1,  0, 0.5,  1,  10);
	  m_Water = Material(1.36, 0);
	  SetWaterColor(Color(1,0,0));
	  Wins->Delete(5);
	  fw5 = 1;
	  Wins->Draw();
	  break;
	case 53: //  ᮪
	  //                           Ka   Kd   Ks   Kt   p
	  Surf_Water = SurfaceProperty( 1,  0, 0.5,   1, 10);
	  m_Water = Material(1.33, 0);
	  SetWaterColor(Color(0, 1, 0));
	  Wins->Delete(5);
	  fw5 = 1;
	  Wins->Draw();
	  break;
	case 54: // 
	  //                           Ka   Kd  Ks  Kt   p
	  Surf_Water = SurfaceProperty( 1, 0.2, 0.2, 0.2, 50);
	  m_Water = Material(1.33, 0.2);
	  SetWaterColor(Color(1, 1, 1));
	  Wins->Delete(5);
	  fw5 = 1;
	  Wins->Draw();
	  break;
	case 59:
	  Wins->Delete(5);
	  fw5 = 1;
	  if (fw3)
	    {
	      Wins->Read(3);
	      fw3 = 0;
	    }
	  Wins->Draw();
	  break;
	case 60:
	  Wins->Delete(6);
	  fw6 = 1;
	  Wins->Draw();
	  break;
	case 61:
	  Alfa = atof(InputLine);
	  if (Alfa<0 || Alfa>90) Alfa = 10;
	  Alfa = Alfa*M_PI/180;
	  break;
	case 70:
	  Wins->Delete(7);
	  fw7 = 1;
	  Wins->Draw();
	  break;
	case 71:
	  L.C.X = atof(InputLine);
	  if (L.C.X>-100 && L.C.X<100) L.C.X=100;
	  break;
	case 72:
	  L.C.Y = atof(InputLine);
	  break;
	case 73:
	  L.C.Z = atof(InputLine);
	  if (L.C.Z>-100 && L.C.Z<100) L.C.Z=-100;
	  break;
	case 74:
	  L.I.R = L.I.G = L.I.B = atof(InputLine);
	  break;
      }
}

void main(int argc, char *argv[])
{
  set_new_handler(MemoryHandler);
  Application* App = new Application;
  ctrlbrk(CtrlBreakHandler);
  for (int i=0; i<argc; i++)
    if (strstr(argv[i],"s")!=NULL)
      {
	fSpeed = 1;
	break;
      }
  App->Run();
  delete App;
}