#include "plane.h"

#include <math.h>

Plane::Plane(double A, double B, double C, double D)
// A*x + B*y +C*z + D = 0   -  ࠢ ᪮
{
  n = Vector(A,B,C);
  double len = !n;
  n = n/len;
  p = D/len;
}

//   窠
Plane::Plane(Point P1, Point P2, Point P3)
{
  P2 = P2 - P1;
  P3 = P3 - P1;
  double
    A =  P2.Y*P3.Z - P3.Y*P2.Z,
    B = -P2.X*P3.Z + P3.X*P2.Z,
    C =  P2.X*P3.Y - P3.X*P2.Z,
    D = -P1.X*A + P1.Y*B - P1.Z*C;
  n = Vector(A,B,C);
  double len = !n;
  n = n/len;
  p = fabs(D/len);
}

//   ଠ  窥
Plane::Plane(Point P, Vector V)
{
  n = V;
  double len = !n;
  n = n/len;
  p = -(P.X*V.X+P.Y*V.Y+P.Z*V.Z)/len;
}

char Plane::Intersect(const Ray& ray, double& d, Point& P)
{
  double vd = n&ray.Dir;
  if (vd>-EPS && vd<EPS) return 0;
  d = -((n&Vector(ray.P))+p)/vd;
  P = ray.P + ray.Dir * d;
  return d>GeomThreshold;
}

Vector Plane::Normal(const Point&)
{
  return n;
}
