#include "parabol.h"

#include "math1.h"
#include <math.h>

Paraboloid::Paraboloid(double k, double h1, double h2)
{
  Y0 = 0;
  H1 = h1;
  H2 = h2;
  K = k;
}

Paraboloid::Paraboloid(double h1, double r1, double h2, double r2)
{
  if (h1>h2)
    {
      swap(h1,h2);
      swap(r1,r2);
    }
  Y0 = (r2*r2*h1 - r1*r1*h2)/(r2*r2 - r1*r1);
  H1 = h1;
  H2 = h2;
  K = r2*r2/(h2-Y0);
}

char Paraboloid::Intersect(const Ray& r, double& t, Point& P)
{
  double t1,t2;
  Ray ray(Point(r.P.X, r.P.Y-Y0, r.P.Z), r.Dir);
  char
    i = SquareEq(
      sqr(ray.Dir.X) + sqr(ray.Dir.Z),
      2*(ray.P.X*ray.Dir.X + ray.P.Z*ray.Dir.Z) - K*ray.Dir.Y,
      sqr(ray.P.X) + sqr(ray.P.Z) - K*ray.P.Y,
      t1, t2);
  if (!i) return 0;

  P = ray.P + t1*ray.Dir;
  P.Y = P.Y + Y0;
  if (t1>GeomThreshold && H1<P.Y && P.Y<H2)
    {
      t = t1;
      return 1;
    }
  if (i==1) return 0;

  P = ray.P + t2*ray.Dir;
  P.Y = P.Y + Y0;
  if (t2>GeomThreshold && H1<P.Y && P.Y<H2)
    {
      t = t2;
      return 1;
    }
  else
    return 0;
}

Vector Paraboloid::Normal(const Point& P)
{ //			      ?
  return Normalize(Vector(P.X,0,P.Z));
}
