#include "math1.h"

#include <math.h>

double sqr(double x)
{
  return x*x;
}

// ।⥫
double det(double a11,double a12,
	   double a21,double a22)
{
  return a11*a22 - a12*a21;
}

double det(double a11,double a12,double a13,
	   double a21,double a22,double a23,
	   double a31,double a32,double a33)
{
  return
    + a11*a22*a33
    + a12*a23*a31
    + a13*a21*a32
    - a13*a22*a31
    - a11*a23*a32
    - a12*a21*a33;
}

void swap(double& A, double& B)
{
  double C;
  C = A;
  A = B;
  B = C;
}

// ⭮ ࠢ - The square equation
// A*x*x + B*x + C = 0
//
// 0 -  襭
// 1 -  襭 (X1)
// 2 -  襭 (X1,X2)
char SquareEq(double A, double B, double C, double& X1, double& X2)
{
  if (A==0) // ࠢ
    if (B==0)
      return 0;
    else
      {
	X1 = -C/B;
	return 1;
      }
  else
    {
      double D = sqr(B) - 4*A*C;	//ਬ
      if (D<0)
	return 0;
      else
	if (D>0)
	  {
	    D = sqrt(D);
	    X1 = (-B - D)/2/A;
	    X2 = (-B + D)/2/A;
	    return 2;
	  }
	else
	  {
	    X1 = -B/2/A;
	    return 1;
	  }
    }
}

char sign(double x)
{
  if (x>0)
    return 1;
  else
  if (x<0)
    return -1;
  else
    return 0;
}