#include "circle.h"
#include "math1.h"

//   窠  㦭
Circle::Circle(Point P1, Point P2, Point P3): Plane(P1,P2,P3)
{
  // । न 業
  Vector
    n1(P1,P2),
    n2(P2,P3);
  double
    d1 = n1&((P1+P2)/2),
    d2 = n2&((P2+P3)/2),
    d = -p;
  // ᪮: 1:{n1,d1}, 2:{n2,d2}, 3:{n,d}
  double
    D = det(n1.X,n1.Y,n1.Z, n2.X,n2.Y,n2.Z, n.X,n.Y,n.Z);
  //if (D==0) return;
  P.X = det(d1,n1.Y,n1.Z, d2,n2.Y,n2.Z, d,n.Y,n.Z)/D;
  P.Y = det(n1.X,d1,n1.Z, n2.X,d2,n2.Z, n.X,d,n.Z)/D;
  P.Z = det(n1.X,n1.Y,d1, n2.X,n2.Y,d2, n.X,n.Y,d)/D;
  R = (P,P1);//R = (P,P2);R = (P,P3);
}

Circle::Circle(Plane Pl, Point p, double r): Plane(Pl)
{
  P = p;
  R = r;
}

Circle::Circle(Point p, Vector v, double r): Plane(p,v)
{
  P = p;
  R = r;
}

char Circle::Intersect(const Ray& ray, double& d, Point& P1)
{
  if (Plane::Intersect(ray, d, P1))
    return (P,P1)<R;
  else
    return 0;
}

Vector Circle::Normal(const Point&)
{
  return n;
}
