#ifndef _COLOR_H
#define _COLOR_H

#define	Black		Color(0,0,0)
#define	Blue		Color(0,0,1)
#define	Green		Color(0,1,0)
#define Cyan		Color(0,1,1)
#define	Red		Color(1,0,0)
#define	Magenta		Color(1,0,1)
#define Brown		Color(0.6470588, 0.1647058, 0.1647058)
#define	LightGray	Color(0.7529411, 0.7529411, 0.7529411)
#define	DarkGray	Color(0.5019607, 0.5019607, 0.5019607)
#define	LightBlue	Color(0.7490196, 0.8570588, 0.8570588)
#define	Yellow		Color(1,1,0)
#define	White		Color(1,1,1)

// 
class Color
{
 public:
  double R,G,B;		// ⥭ᨢ
  Color Clip();
  Color(double=0,double=0,double=0);
  Color(const Color&);
  Color& operator=(const Color&);
  char operator==(const Color&);
  char operator!=(const Color&);
  Color operator+(const Color&);
  Color operator*(const Color&);
  Color operator*(const double);
  Color operator/(const double);
 private:
  void Clip(double&);
};

Color operator*(const double, const Color&);

#endif