// 䠩 GLASS.CPP

#include "tetris.h"
#include <string.h>

// ᨢ   ᠭ 䨣
struct Block Blocks[CONST_FIGURES]={
	{"00..00...",3,0},{".0.000...",3,0},
	{"0..000...",3,0},{"..0000...",3,0},
	{".0000....",3,0},{"0000",2,0},
	{".......0....0....0....0..",5,-1}};

//  㠫쭠 㭪 뢮  ࠭
//  䨣  ⮩ 祩
void Glass::PutArea(int x,int y,int color)
{}

// 㠫쭠 㭪 樨 砩 ᫠
int Glass::Randomize()
{
  return(0);
}

// ᤢ 䨣 , ᫨   */
void Glass::DoLeft()
{
  x--;
  // ஢ઠ  ।⮩ 䨣
  if(Check(GET_CUBE)==BE_SUPERPOSITION) x++;
  // ࠦ ।⮩ 䨣  騪
  Show();
}

// ᤢ 䨣 ࠢ, ᫨  
void Glass::DoRight()
{
  x++;
  // ஢ઠ  ।⮩ 䨣
  if(Check(GET_CUBE)==BE_SUPERPOSITION) x--;
  // ࠦ ।⮩ 䨣  騪
  Show();
}

//  䨣, ᫨  
void Glass::DoTurn()
{
  Turn(); Turn();   Turn();
  // ஢ઠ  ।⮩ 䨣
  if(Check(GET_CUBE)==BE_SUPERPOSITION)
     Turn();
  // ࠦ ।⮩ 䨣  騪
  Show();
}

// ஭ ࠬ   ॥
void Glass::QuickFall()
{
  if(y<0) Next();
  Next();
  //  䨣   騪
  while(y>=1) Next();
}

// ⨥  ப,
// ᤢ 䨣    ,
// , ᫨  ,   䨣

int Glass::Next()
{
  int i,j,n,k;

  switch(iStatus) {
    case BE_FALL:        //   ⢫  
      y++;		 //    ஢ 
      if(Check(GET_CUBE)==BE_SUPERPOSITION) {
	y--;              //   㡨ࠥ
	Check(SET_CUBE);  //  ப
	for(n=j=CONST_HEIGTH+1;j!=1;j--) {
	  for(i=0,k=0;i!=CONST_WIDTH;i++) {
	    abyGlass[i+2][n] = abyGlass[i+2][j];
	    if(abyGlass[i+2][n] == ITEM_EMPTY) k++;
	    if(n!=j) abyGlass[i+2][j] = 0;
	  }
	  if(k) n--;
	}
      } else {
	// ࠦ ।⮩ 䨣  騪
	Show();
	break;

      }
    case BE_NEW:
      Figure();    //    䨣

      if(Check(GET_CUBE)==BE_SUPERPOSITION) {
	iStatus=BE_END;
	break;
      }
      // ࠦ ।⮩ 䨣  騪
      Show();
      iStatus = BE_FALL;
  }
  return(iStatus);
}

// ࠦ ।⮩ 䨣  騪
void Glass::Show()
{
  int i,j;
  memcpy(abyTemp,abyGlass,(4+CONST_WIDTH)*(4+CONST_HEIGTH));
  Check(SET_CUBE);
  for(j=0;j!=CONST_HEIGTH;j++)
    for(i=0;i!=CONST_WIDTH;i++)
      if(abyOldGlass[i+2][j+2]!=abyGlass[i+2][j+2]) {
	PutArea(i,j,abyGlass[i+2][j+2]);
	abyOldGlass[i+2][j+2] = abyGlass[i+2][j+2];
      }
  memcpy(abyGlass,abyTemp,(4+CONST_WIDTH)*(4+CONST_HEIGTH));
}

//   Glass
Glass::Glass(void)
{
  int i,j;

  iStatus = BE_NEW;
  for(j=0;j!=CONST_HEIGTH+4;j++) {
    for(i=0;i!=CONST_WIDTH+4;i++) {
      abyGlass[i][j] = abyOldGlass[i][j] = -1;
      if(((i>1)&&(i<CONST_WIDTH+2))&&((j>1)&&(j<CONST_HEIGTH+2)))
	abyGlass[i][j] = 0;
    }
  }
}

// 롮   梥 䨣   
// 砩 ᥫ
void Glass::Figure()
{
  int i,iRnd;

  iRnd = Randomize();
  iAttribute = ((iRnd & 0xff00)>>8)%CONST_COLOR+1;
  i=(iRnd & 0x0ff)%CONST_FIGURES;
  strcpy(pbyMask,Blocks[i].pbyMask);
  iRange = Blocks[i].iRange;
  y = Blocks[i].iUpLine;
  x = (CONST_WIDTH-iRange)/2;
}

// 㭪  䨣
void Glass::Turn()
{
  int offset,i1,i2,i3,pos;
  int range=iRange-1;
  char c;

  if(iRange&1) {
    for(offset=0;offset!=range/2;offset++) {
      for(pos=0;pos!=range-offset*2;pos++) {
	i1=pos+offset;
	i2=range-offset;
	i3=range-pos-offset;
	c=*(pbyMask+offset+i1*iRange);
	*(pbyMask+offset+i1*iRange)=*(pbyMask+i1+i2*iRange);
	*(pbyMask+i1+i2*iRange)=*(pbyMask+i2+i3*iRange);
	*(pbyMask+i2+i3*iRange)=*(pbyMask+i3+offset*iRange);
	*(pbyMask+i3+offset*iRange)=c;
      }
    }
  }
}
// 㭪 ஫  䨣
int Glass::Check(int op)
{
  int i,j;

  for(j=0;j!=iRange;j++)  {
    for(i=0;i!=iRange;i++)  {
      if(*(pbyMask+i+j*iRange)!=BE_EMPTY) {
	switch(op)  {
	case SET_CUBE:
	  abyGlass[i+x+2][j+y+2] = iAttribute;
	  break;
	case GET_CUBE:
	  if(abyGlass[i+x+2][j+y+2]!=ITEM_EMPTY)
	  return (BE_SUPERPOSITION);
	}
      }
    }
  }
  return(BE_FREE);
}