/**********************************************************************

             ᯮ⥫ 㫥 ணࠬ SASIMPL

                   (  ணࠬ SA.CPP)

 , ᮤঠ騩 ।⢥ ஢ ᨯ-⮤
  ⨯⨢ ।⠢ ⭮ 

 ।,  室  㦥  ...
 뢮 १⮢ ந  室 䠩 ...

     ᪮  ( , 
  ࠭祭  ࠢ   㦥  ᢮
  ⢥ ६)   樨

 襭: m x n 砥  ⮩  m ப  ਭ
             n ⮫殢 ;-)

**********************************************************************/

// 襭᪮ ணࠬ ᠭ
#include "sa.h"

#include <setjmp.h>

#define Empty ;

#define NoMem { GError << "\n !!!"; GlobalError(); longjmp(Gjmpbuf,1); }


// 室 䠩  १⠬ ࠡ
char *OutFile = "SASIMPL.RES";

//   䠩,    㪠⥫  ⥬
ofstream OFile;

//************************   *****************************
// (    맮 㭪樨 MultiSimplex() )

//   祭: ⢮ ६
//  ⢮ ࠭祭
int n, m;

//  樥⮢  x   (n ⮢)
double *C = NULL;

//  樥⮢ ࠭祭 (m x n)
Matrix A;

//  ࠢ  ࠭祭 (m ⮢)
double *B = NULL;

//************************  *********************************
int *NXBasis = NULL;     //   ६
double *X = NULL;        // 祭  ६
jmp_buf Gjmpbuf;         // 猪 㭤

//*******************  -    **************
class EMatrix
{
public:
  static int N;  // ࠧ   NxN
  int fl;        //  ।⠢   (0 -  ᨢ, n - 
                 // ,  n - - ⮢  )
  // ।⠢ ⮫ ୮ ,  ᮤন 
  union E_Data
  {
    double *E;     //    ᨢ (᫨   0- ⮢)
    struct E_Ef    //    , ࠭饩 ⮫쪮  0- .
    { int n; double En; } *Eef;
  } Edata;

  int Column;      //  ⮫ ୮ , ࠭饣 
  EMatrix *Next;   // ᫥ ୠ  ᯨ᪠

  void Init( void );    // 㭪 樠樨 ᯨ᪠
  void destroy( void ); // 㭪 㭨⮦ ᯨ᪠

public:
  EMatrix(){ Init(); }                //   㬮砭 (ᯨ᪠)
  EMatrix( int h ){ Init(); N = h; }  //   ୮ .
  ~EMatrix(){ destroy(); }            // 
  void Add( double *e, int column );  //   ᯨ᮪ . 
  EMatrix &operator[]( int n );       //   ᯨ᪠ . 
  double Get( int n );                //    . 
};

// ***       ***
void EMatrix::Init( void )
{
  Next = NULL;
  fl = 0;
  Edata.E = NULL;
}

void EMatrix::Add( double *e, int column )
{
  EMatrix *s = this;
  if( this->Edata.E != NULL || this->Edata.Eef != NULL )
  {
    while( s->Next != NULL ) s = s->Next;
    s->Next = new EMatrix; if(s->Next == NULL ) NoMem;
    s = s->Next;
  }
  // ⠥ - 㫥 ⮢
  int sk = 0;
  for( int i = 0; i < N; i++ ) if( e[i] ) sk++;

  if( N * sizeof(double) < sk * sizeof(E_Data::E_Ef) )
  {
    s->fl = sk;
    s->Edata.Eef = new E_Data::E_Ef [sk]; if( s->Edata.Eef == NULL ) NoMem;
    for( i = 0, sk = 0; i < N; i++ )
      if( e[i] ){ s->Edata.Eef[sk].n = i; s->Edata.Eef[sk].En = e[i]; sk++; }
  }
  else
  {
    s->fl = 0;
    s->Edata.E = new double [N]; if( s->Edata.E == NULL ) NoMem;
    for( i = 0; i < N; i++ ) s->Edata.E[i] = e[i];
  }
  s->Column = column;
}

void EMatrix::destroy( void )
{
  if( Next != NULL ) delete Next;
  if( fl )
    if( Edata.Eef != NULL ) delete Edata.Eef;
  else
    if( Edata.E != NULL ) delete Edata.E;
  Next = NULL; Edata.E = NULL; fl = 0;
}

EMatrix &EMatrix::operator[]( int n )
{
  EMatrix *s = this;
  for( int i = 0; i != n; i++, s = s -> Next ) Empty;
  return *s;
}

double EMatrix::Get( int n )
{
  if( fl )
  {
    for( int i = 0; i < fl; i++ )
    {
      if( Edata.Eef[i].n == n ) return Edata.Eef[i].En;
      if( Edata.Eef[i].n > n ) break;
    }
    return 0.;
  }
  return Edata.E[n];
}

int EMatrix::N = 0;

//****************   ***********************************

//    砫 
void FindBasis( void )
{
  for( int j = 0; j < n; j++ )
  {
    for( int i = 0; i < m; i++ )
    {
      // 饬 ६  . 1  ࠭祭 ( ६ j)
      if( A[i][j] == 1 )
      {
        // ஢塞    㦥  
        for( int k = 0; NXBasis[k] != -1 &&
                        NXBasis[k] != j && k < m; k++ ) Empty;
        if( NXBasis[k] != j )
        {
          // ...᫨ ,  ஢塞 樥  ⮫
          // ࠭祭 ⮩ ६
          for( int k = 0; k < m; k++ ) if( k != i ) if( A[k][j] ) break;
          if( k == m )
          {
            // ᫨  Ob,  ᨬ  ६  
            for( int l = 0; NXBasis[l] != -1 && l < m; l++ ) Empty;
            NXBasis[l] = j;
            if( l == m - 1 ) return;  //  ६ 諨
            break; // 室   ப ࠭祭
          }
        }
      }
    }
    if( j == n )
    {
      GError << "\n    ணࠬ஢  \n"
             << "   ᪮  .   ,  \n"
             << " ࠭祭 㦥  ⢮ !\n"
             << " ணࠬ  -  室...\n"
             << err_torun;
      GlobalError(); longjmp( Gjmpbuf, 1);
    }
  }
}

// ⮢⥫쭠 ࠡ
void BeforeTimeWork( void )
{
  if( NXBasis != NULL ) delete NXBasis;
  NXBasis = new int [ m ]; if( NXBasis == NULL ) NoMem;
  for( int i = 0; i < m; i++ ) NXBasis[i] = -1;
  FindBasis();    // 饬 砫 
  // 塞 祭  ६  ࠢ  B
  if( X != NULL ) delete X; X = new double [ m ]; if( X == NULL ) NoMem;
  for( i = 0; i < m; i++ ) X[i] = B[i];
}

//  ࠡ
void AfterTimeWork( void )
{
  if( NXBasis != NULL ){ delete NXBasis; NXBasis = NULL; }
  if( X != NULL ){ delete X; X = NULL; }
}

// ।⢥ ॠ ᨬ-⮤  ⨯뢭
// ।⠢ ⭮ ᭮ 
void MultiSimplex( void )
{
  BeforeTimeWork(); // ।⥫쭠 ⮢ ( . ,...)

  EMatrix E( m + 1 ); // 樠 ᯨ᪠  

  Matrix Cx( 1, m ); // 樥    ६

  for( int iteration = 0; ; iteration++ )
  {
    int i;
    // 塞  Cx - .-    ६
    for( i = 0; i < m; i++ ) Cx[0][i] = C[ NXBasis[i] ];

    { // 뢮 祭  ६
    char str[10]; Ccputs( 4, itoa(iteration,str,10) );
    OFile << " N" << iteration << endl
          << "祭  ६:\n";
    for( i = 0; i < m; i++ )
      OFile << "X" << (NXBasis[i]+1) << " = " << X[i] << endl;
    }
    { // 뢮 祭 楫 㭪樨
    Matrix bb(m,1,X);
    Matrix *aaa = Cx * bb;
    OFile << "祭 楫 㭪樨: " << (*aaa) << endl;
    delete aaa;
    }

    //  ⢥ ६
    Matrix Pi( 1, m );
    if( iteration )
    {
      for( i = iteration - 1; i >= 0; i-- )
      {
        double Sum = 0;

        for( int j = 0; j < m; j++ )
        {
          double a = E[i].Get(j);
          if( a )
          {
            double b = Cx[0][j];
            if( b )
              Sum += a * b;
          }
        }
        Cx[0][E[i].Column] = Sum;
      }
    }
    Pi = Cx;

    // 宦  ६
    double c_min = 9e100, s_min = -1;
    for( i = 0; i < n; i++ )
    {
      Matrix *P_itoe = A.GetColumn( i );
      Matrix *P = Pi * (*P_itoe);

      double c = C[i] - (*P)[0][0];
      if( c < c_min ){ c_min = c; s_min = i; }

      delete P_itoe; delete P;
    }
    //  ६  ᮬ s_min

    if( c_min >= -0.1e-12 )        //  ⨬஢ 㤠...
    {                              // -0.1e-12 -   
      OFile << "\n 襭"  //              -  譮 :-(
               "  ⨬!\n";
      break;
    }

    // ᫥ 饣 ⮫
    Matrix *P_soe = A.GetColumn( s_min );
    Matrix AA( m, 1 );
    AA = *P_soe;
    for( i = 0; i < iteration; i++ )
    {
      int clmn = E[i].Column;
      for( int j = 0; j < m; j++ )
      {
        if( j != clmn )
          AA[j][0] += E[i].Get(j) * AA[clmn][0];
      }
      AA[clmn][0] *= E[i].Get(clmn);
    }
    // ...   ⥯  AA

    // ஢, ᫨     ⥫, 
    // ⢮ 襭 ࠭祭...
    for( i = 0; i < m; i++ ) if( AA[i][0] > 0  ) break;
    if( i == m )
    {
      OFile << "\n⨬ ࠭祭...!\n";
      break;
    }

    // 饬 뢮 ६  
    double th_min = 9e100;
    int r_min = -1;
    for( i = 0; i < m; i++ )
    {
      if( AA[i][0] > 0 )
      {
        double th = X[i]/AA[i][0];
        if( th < th_min ){ th_min = th; r_min = i; }
      }
    }
    // 뢮   r_min- ६

    // 塞  ᯨ᮪    
    // ஬, ⮣ 塞 ⭮ 祭  ६
    double *EE = new double [ m ]; if( EE == NULL ) NoMem;
    for( i = 0; i < m; i++ )
    {
      if( i != r_min )
      {
        EE[i] = - AA[i][0] / AA[r_min][0];
        X[i] = X[i] - th_min * AA[i][0];
      }
    }
    EE[r_min] = 1. / AA[r_min][0];
    X[r_min] = th_min;
    NXBasis[r_min] = s_min;
    E.Add( EE, r_min );
    delete EE;

    delete P_soe;
  }
  AfterTimeWork();
}

//   㭪 襣 ⮤
//   ᭮ 室  ᮧ 室 䠩  室묨 १-
int MSimplex( void )
{
   OFile.open( OutFile );
   if( !OFile )
   {
     GError << "\n ᮧ 室 䠩: " << OutFile;
     GlobalError();
     return 0;
   }

   { // 뢮 室 
   OFile << "室 :\n";
   OFile << "⢮ ६  n = " << n << endl
         << "⢮ ࠭祭 m = " << m << endl;

   Matrix R( 1, n, C );
   OFile << " 樥⮢ 楫 㭪樨 C:\n" << R << endl;
   OFile << " 樥⮢  ࠭祭 A:\n" << A << endl;
   Matrix RR( 1, m, B );
   OFile << " ࠢ  ࠭祭 B:\n" << RR << endl;
   OFile << "********************************************************\n";
   }

   int value = setjmp( Gjmpbuf );
   if( value == 1 ){ return 0; } // For Whom The Bell Tolls...?
                                 // Time Matches On!
   MultiSimplex();

   OFile.close();

   return 1;
}




