//Ŀ
//             ⥪ TSWM.LIB                   
// ⨯ 㭪権,   । ⠭ 
//      ࠡ  ࠭  ⥪⮢ ०.      
//

#ifndef TSTYPES
#include <tstypes.h>
#endif

#ifndef WHITE
#include <conio.h>
#endif

#include <string.h>
#include <dos.h>

#define LANGUAGE extern byte language
#define ENGLISH byte language=0
#define RUSSIAN byte language=1


#define ATTR(color,back)       ((back<<4)|color)
#define COLOR(attr)            (attr&0x0f)
#define BACK(attr)             (attr>>4)

//---------------ᯮ⥫ p---------------------

enum{ NONE,
           LEFT_TOP,     CENTER_TOP,     RIGHT_TOP,
           LEFT_CENTER,  CENTER,         RIGHT_CENTER,
           LEFT_BOTTOM,  CENTER_BOTTOM,  RIGHT_BOTTOM,
      ALL };

#ifndef NULL
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
#define NULL    0
#else
#define NULL    0L
#endif
#endif

//============================= p p =======================

void StartMonitor(void);
void FinishMonitor(void);
void GoTimer(void);
void StopTimer(void);
void GoMonitor(void);
void StopMonitor(void);

//=============================  ============================

#define TAB_SIZE 8

//--------- -     --------

#define LEFT   0x4b
#define RIGHT  0x4d
#define UP     0x48
#define DOWN   0x50
#define HOME   0x47
#define END    0x4f
#define PGUP   0x49
#define PGDN   0x51
#define ENTER  0x1c
#define SPACE  0x39
#define INSERT 0x52
#define DELETE 0x53
#define BACKSP 0x0e
#define ESC    0x01
#define TAB    0x0f
#define PLUS   0x4e
#define MINUS  0x4a
#define F0     0x3a
#define F11    0x57
#define F12    0x58
#define LSHIFT 0x2a
#define RSHIFT 0x36
#define CTRL   0x1d
#define ALT    0x38

#define FREE   0x80 //   ᪠-  ᪠ 

struct KBD {
  byte flag;
  byte state;
  byte scan;
  byte sym;

  int Test(int opt=0);
  int Wait(int opt=0);
  void Clear(void);
  int Shift(void) { return state&0x01; }
  int Ctrl(void)  { return state&0x02; }
  int Alt(void)   { return state&0x04; }
  int Caps(void)  { return state&0x08; }
  int Num(void)   { return state&0x10; }
  int Scroll(void){ return state&0x20; }
  int Func(void) {
      if(scan==F11)return 11;
      if(scan==F12)return 12;
      int i=scan-F0;
      if(i>0&&i<11)return i;
      return 0;
      }
  };

#define KEYBOARD extern KBD Kbd

struct HotKey {
  HotKey *next;
  HotKey *prev;
  byte flag;
  byte state;
  byte scan;
  void (*func)(void);
  byte param[40];

  HotKey(byte st, byte sc, void (*f)(void),...);
  ~HotKey(void);
  };

void HelpHotKey(void);

            //  䠩, p, ᨢ 梥⮢(,pp)
void SetHelp(char *,char *,char *);
void SetHelp(char *);

//============================= H ============================

extern byte ScreenPer;  //  䫠 ᫠ p
                        // 0 - ᮫;
                        // 1 - x,y - p業  p, width,height - ᮫.
                        // 2 -  p業  p

extern TI T;            // 쭠 pp textinfo

#define VideoStart ((VideoText *)0xB8000000l)
#define Color_ATOM "\xC\xD\xE\xF\xB\xA\x7\x3\x2\x9\x8\x4\x6\x5"

inline int Coordx(int x) {
  if(ScreenPer) return (T.screenwidth*x+x/2)/100;
  return x;
  }
inline int Coordy(int y) {
  if(ScreenPer) return (T.screenheight*y+y/2)/100;
  return y;
  }
inline int Sizew(int w) {
  if(ScreenPer>1)return (T.screenwidth*w+w/2)/100;
  return w;
  }
inline int Sizeh(int h) {
  if(ScreenPer>1)return (T.screenheight*h+h/2)/100;
  return h;
  }
void Att(byte, byte, byte, byte, byte);
inline void Att(byte left, byte top, byte length, byte attr) {
  Att(left,top,length,1,attr);
  }
byte Att(byte,byte);
void Att(byte,byte,byte);
void PutText(byte,byte,byte,byte,VideoText *);
void PutText(byte,byte,byte,byte);
void GetText(byte,byte,byte,byte,VideoText *);
void Color1(byte,byte,byte);

byte SelectAttr(byte x, byte y, byte attr, char *title);
byte SelectColor(byte x, byte y, byte attr, char *title);

int  StoreScreen(void);
void RestoreScreen(void);

#define SCREENOFF extern ScreenOff ScrOff

struct ScreenOff {
  char *line[3];
  word count;
  word limit;
  void (*Switch)(void);
  };

void ScreenOffSet(word,void (*)(void),char *,char *,char *);
void PingPong(void);
void Worms(void);

void DisplayTime(byte x, byte y, byte attr);
void DisplayTimeOff(void);

void ChangePalette(byte color, byte value);
void ChangeAllPalette(byte *values);
void SavePalette(void);
void RestorePalette(void);
void NewPalette(byte *values);

void SetBackGround(int);
void SetBackGround(void);

struct CG {
  byte *xy;
  byte lx;
  byte *colors;
  byte lc;
  byte curcolor;
  byte active;
  byte wait;
  byte count;
  byte oldcolor;

  void Step(void);
  };

class ColorGo {
  CG *cg;
  byte n;
  ColorGo *old;
public:
  friend void interrupt Monitor(...);
  void Activate(void);
  void Deactivate(void);
  ColorGo(byte nc);
  ~ColorGo(void);
  int Insert(byte w, byte *col, byte x, byte y,...);
  void Delete(int handler);
  void DeleteNo(int handler);
  void On(int handler);
  void Off(int handler);
  void OffNo(int handler);
  };


//===============================  ===================================

// 
//     

#define B_SINGLE  "Ŀ"
#define B_DOUBLE  "ͻȺ"
#define B_DOUBLE2 "˻"
#define B_HSVD    "ķӺ"
#define B_HDVS    "͸Գ"
#define B_SOLID   ""
#define B_SOLID1  ""
#define B_SOLID2  ""
#define B_NONE    ""

void Contour(byte attr, byte *border, int x, int y,...);
inline void Box(byte a, byte *bo, byte x, byte y, byte dx, byte dy) {
  Contour(a,bo,x,y,x+dx-1,-(y+dy-1),x,-y,0);
  }

class TSWIN {
  byte visual    ;
  byte attr_win  ;
  byte attr_bor  ;
  byte shadow    ;
  byte attr_sha  ;
  byte fill_char ;
  byte left      ;
  byte top       ;
  byte width     ;
  byte height    ;
  byte border[8] ;
  TI tt;
  VideoText *buf ;
  VideoText *hsha;
  VideoText *vsha;

  void Build(byte,byte,byte,byte);
  VideoText *GetW(void);
  void PutW(VideoText *);
  int GetB(VideoText **,VideoText **,VideoText **,VideoText **);
  void PutB(VideoText *,VideoText *,VideoText *,VideoText *);
  int GetS(VideoText **,VideoText **);
  void PutS(VideoText *,VideoText *);

public:
//=========================== 樠 (梥   pp)
  TSWIN(byte a = 0x17) {
    gettextinfo(&T);
    tt=T;
    visual=0;
    attr_win=attr_bor=a;
    attr_sha=0x08;
    shadow=NONE;
    fill_char=32;
    left=top=1;
    width=T.screenwidth;
    height=T.screenheight;
    Border(B_DOUBLE);
    buf=hsha=vsha=NULL;
    }
  ~TSWIN(){ Close(); }                    // 
  void AttrWin(byte);                     // p 梥 
  void AttrBor(byte);                     // p 梥 pp
  void Shadow(byte s, byte at=0x08);      //   p ⥭
  void FillChar(byte);                    // -⥫
  void Refresh(byte c=0);
  void Border(char *e);
  void Locate(byte,byte,byte,byte,byte position=LEFT_TOP);
  void Locate(byte x, byte y) {
    Locate(x,y,width,height);
    }

  void PutTitle(byte,byte,char*);
  void PrintTitle(byte,byte,const char*,...);
  void PutTitle(char *text) { PutTitle(CENTER_TOP,attr_bor,text); }
  void ClearTitle(byte position=ALL);
  void Put(byte exp=NONE,int exp_speed=0);
  void Open(byte exp=NONE,int exp_speed=0);
  void Close(void);
  void Set(void) {
    byte w=(border[0]!=0);
    window(left+w,top+w,left+width-w-1,top+height-w-1);
    textattr(attr_win);
    gotoxy(1,1);
    gettextinfo(&T);
    }
  };


//========================== p⮥  ================================

#define _F1      0x00000001
#define _F2      0x00000002
#define _F3      0x00000004
#define _F4      0x00000008
#define _F5      0x00000010
#define _F6      0x00000020
#define _F7      0x00000040
#define _F8      0x00000080
#define _F9      0x00000100
#define _F10     0x00000200
#define _F11     0x00000400
#define _F12     0x00000800
#define _OTHER   0x00001000
#define _HOME    0x00002000
#define _END     0x00004000
#define _PGUP    0x00008000
#define _PGDN    0x00010000
#define _INS     0x00020000
#define _DEL     0x00040000
#define _UP      0x00080000
#define _DOWN    0x00100000
#define _LEFT    0x00200000
#define _RIGHT   0x00400000
#define _OUP     0x00800000
#define _ODOWN   0x01000000
#define _OLEFT   0x02000000
#define _ORIGHT  0x04000000
#define _TAB     0x08000000
#define _PLUS    0x10000000
#define _MINUS   0x20000000
#define _FUNC    0x00000fff

struct ME {
  byte  x,  y       ;    //  
  byte dx, dy       ;    // p   
  char *comment     ;    //  p  
  };

class TSMENU {
  ME   *m         ;    // 뫪  ᨢ ⮢ 
  byte nm         ;    // ⢮ ⮢ 
  byte current    ;    //  ⥪饣  
  byte type       ;    //  
  byte curattr    ;    // p ⥪饣 
  byte *colors    ;    // Hp 梥⮢  ColorGo
  byte wait       ;    // p  ColorGo
  int  hand       ;    // Handler  ColorGo
  byte commattr   ;    // Ap p
  char *comm      ;    // 뫪  ᨢ p
  char *lcomm     ;    // Cc뫪  ᢮   ᨢ p
  byte commx      ;    //  p p
  byte commy      ;    //  p p
  dword keys      ;    // K  室
  dword c_keys    ;    // K  室 + CTRL
  dword a_keys    ;    // K  室 + ALT
  dword s_keys    ;    // K  室 + SHIFT
  VideoText *it   ;    //  ⥪饣 
  void (*cur)(TSMENU *);  // 㭪 뤥 ⥪饣

  void Store(void);
  void Restore(void);
  int  LookFor(int);
  int  TestKey(dword);

public:
  friend void Attr(TSMENU *);
  friend void Border(TSMENU *);
  friend void ItemCG(TSMENU *);
  friend void BorderCG(TSMENU *);

  TSMENU(byte n, word nc=0) {
    m=NULL;
    if(n)m=new struct ME[n];
    nm=n;
    type=current=curattr=commattr=commx=commy=0;
    comm=NULL;  it=NULL;
    if(nc)comm=lcomm=new char[nc];
    keys=c_keys=a_keys=s_keys=0;
    cur=Attr;
    colors=(byte *)Color_ATOM;
    wait=2;
    hand=-1;
    gettextinfo(&T);
    }

  ~TSMENU(void) {
    if(it) Restore();
    if(m) delete m;
    if(comm) delete comm;
    }

  void Color(byte ca) {
    curattr=ca;
    }

  void Color(byte w, char *col) {
    wait=w;
    colors=(byte *)col;
    }

  int Current(void) {
    return current;
    }

  void Current(byte c) {
    current=c;
    }

  void Comment(byte x, byte y, byte ca) {
    commx=Coordx(x); commy=Coordy(y);
    commattr=ca;
    }

  void CurrentShow(void (*show)(TSMENU *)) {
    cur=show;
    }

  void Keys(dword uk, dword ck=0, dword ak=0, dword sk=0) {
      keys=uk; c_keys=ck;
    a_keys=ak; s_keys=sk;
    }

  void Item(byte ix, byte iy, byte il, byte ih, char *c=NULL);
  void Item(byte ix, byte iy, byte il, byte ih, char *l, char *c);
  void Item(byte ix, byte iy, byte il, char *l, char *c=NULL) {
    Item(ix,iy,il,1,l,c);
    }
  void Item(byte ix, byte iy, char *l, char *c=NULL) {
    Item(ix,iy,strlen(l),1,l,c);
    }
  void Item(byte ix, byte iy, byte il) {
    Item(ix,iy,il,1);
    }
  byte Exec(void);
  };

//=========================   pp⪮ ===================

class SCROLLMENU {
protected:
  void *m         ;    // 뫪  ᨢ ⮢ 
  word nm         ;    // ⢮ ⮢ 
  word el         ;    //   ᨢ
  byte ll         ;    // ᨬ쭠  p 㭪 
  byte mb         ;    // Hp   ⪨
  byte bi         ;    // ᪠   ⪨
  word current    ;    //  ⥪饣  
  void (*curfunc)(byte x, byte y, void *item);
  byte curattr    ;    // p ⥪饣 
  byte selattr    ;    // p 祭 
  dword keys      ;    // K  室
  dword c_keys    ;    // K  室 + CTRL
  dword a_keys    ;    // K  室 + ALT
  dword s_keys    ;    // K  室 + SHIFT
  int  TestKey(dword);

public:

  SCROLLMENU(void *pm, word pnm, word pel, byte pll) {
    m=pm; nm=pnm; el=pel; ll=pll;
    mb=bi=current=selattr=0;
    keys=c_keys=a_keys=s_keys=0;
    curattr=0x4e;
    curfunc=NULL;
    }

  ~SCROLLMENU(void) {
    }

  void Color(byte ca) {
    curattr=ca;
    }

  void CurFunc(void (*cf)(byte,byte,void*)) {
    curfunc=cf;
    }

  int Current(void) {
    return current;
    }

  void Current(byte c) {
    current=c;
    }

  void Selector(byte sa, byte pmb, byte pbi) {
    selattr=sa;
    mb=pmb;
    bi=pbi;
    }

  void Keys(dword uk, dword ck=0, dword ak=0, dword sk=0) {
      keys=uk; c_keys=ck;
    a_keys=ak; s_keys=sk;
    }

  int Exec(void);
  };

//=========================   pp ===================

struct EDITMENU;

struct EditItem {
  int (*func)(int,EDITMENU *);// 뫪  㭪 ।஢
  void *ptr;                  // ⥫  塞  
  byte param[40];             // Mᨢ pp pp
  byte x, y;                  //  
  char *comment;              //  p  
  };


struct EDITMENU {
  EditItem *m     ;    // 뫪  ᨢ ⮢ 
  byte nm         ;    // ⢮ ⮢ 
  byte nc         ;    // 稪 樠p ⮢
  byte update     ;    // ⥫ 
  byte mode       ;    // 1 -  , 0 - 
  byte current    ;    //  ⥪饣  
  byte normattr   ;    // p ⨢ 
  byte curattr    ;    // p ⥪饣  砫 p樨
  byte editattr   ;    // p ⥪饣 ᫥ 砫 p樨
  byte commattr   ;    // p p  㭪⠬
  byte askattr    ;    // p  
  byte x, y       ;    //  p  㭪⠬
  byte maxcomm    ;    // ᨬ쭠  p
  dword keys      ;    // K  室
  TI   t          ;
  int LookFor(int);

  EDITMENU(byte pnm, byte mod=1, dword uk=0l) {
    gettextinfo(&T);
    t=T;
    nc=pnm;
    keys=uk;
    mode=mod;
    maxcomm=commattr=current=normattr=curattr=editattr=x=y=nm=update=0;
    m=new EditItem[nc];
    }

  ~EDITMENU(void) {
    delete m;
    }

  void Color(byte ca, byte aa, byte ea=0, byte na=0) {
    curattr=ca;
    askattr=aa;
    if(ea)editattr=ea;
    else editattr=t.attribute;
    if(na)normattr=na;
    else normattr=t.attribute;
    }

  void Comment(byte cx, byte cy, byte coa) {
    x=Coordx(cx); y=Coordy(cy);
    commattr=coa;
    }

  void Current(byte c) {
    current=c;
    }

  byte Current( void ){ return current; }

  void Item(byte ix, byte iy, char *h, char *c,
            void *val,int (*f)(int,EDITMENU *),...);

  void Item(byte ix, byte iy, void *val, int (*f)(int,EDITMENU *),...) {
    if(nm>=nc)return;
    m[nm].x=Coordx(ix); m[nm].y=Coordy(iy);
    m[nm].ptr=val;
    m[nm].func=f;
    m[nm].comment=NULL;
    memcpy(m[nm].param,...,40);
    nm++;
    }

  void Items(void);
  int Exec(int j, char *ok=NULL, char *ed=NULL, char *ca=NULL);
  };

//------------------------------- 㭪樨 pp --------
  int String(int,EDITMENU *);
  int Password(int,EDITMENU *);
  int Long(int,EDITMENU *);
inline int Int(int flag,EDITMENU *em) {
               long a=*((int *)(em->m[em->current].ptr));
               void *oldptr=em->m[em->current].ptr;
               em->m[em->current].ptr=&a;
               int i=Long(flag,em);
               em->m[em->current].ptr=oldptr;
               *((int *)(em->m[em->current].ptr))=(int)a;
               return i;
               }
inline int Byte(int flag,EDITMENU *em) {
               long a=*((byte *)(em->m[em->current].ptr));
               void *oldptr=em->m[em->current].ptr;
               em->m[em->current].ptr=&a;
               int i=Long(flag,em);
               em->m[em->current].ptr=oldptr;
               *((byte *)(em->m[em->current].ptr))=(byte)a;
               return i;
               }
  int Double(int,EDITMENU *);
inline int Float(int flag,EDITMENU *em) {
               double a=*((float *)(em->m[em->current].ptr));
               void *oldptr=em->m[em->current].ptr;
               em->m[em->current].ptr=&a;
               int i=Double(flag,em);
               em->m[em->current].ptr=oldptr;
               *((float *)(em->m[em->current].ptr))=(float)a;
               return i;
               }
  int LineMenu(int,EDITMENU *);
  int ScrollEdit(int, EDITMENU *);

//================== 樨  ⮩ ==================

//।⠢ :
//  word - ᫮   砫 
//  Digit (char*) - dd/mm/yy
//  Solid (char*) - ddmmyy
//  Text  (char*) - 12 ᥭ 93 .

struct Monthes {
  int days;
  char name[12];
  };

extern Monthes Mon[];

int  NormDate(int,int,int);
word Date(char *d);
char *DateDigit(word d, char *buf);
char *DateSolid(word d, char *buf);
char *DateSolid(char *dat);
char *DateText(word d, char *buf);
char *DateText(char *d, char *buf);
word CurrentDate(void);

int  Date(int,EDITMENU *);  //  ।⠢ WORD
int  DateD(int,EDITMENU *); //  ।⠢ Digit

//========================================================================

class Indic {
  byte len;
  byte cur;
  byte curc;
  byte x;
  byte y;
  double one;
  double prev;
  byte n;
  VideoText vt[5];

public:

  Indic(int, int, int, double,...);
  operator +=(double);
  };

//========================================================================

inline void SetText(void) {
  window(T.winleft,T.wintop,T.winright,T.winbottom);
  textattr(T.attribute);
  gotoxy(T.curx,T.cury);
  }
byte cursor(unsigned);
#define cursorON cursor(0xfffb)
#define cursorOFF cursor(0xfa)
#define cursorTEST cursor(0xfffc)
void Ccputs(byte y, char *text);
void Ccprintf(byte y,char *fmt, ...);
void Acputs(char *text);
void vAcprintf(char *, void *);
inline void Acprintf(char *fmt,...) {
  void *a=...;
  vAcprintf(fmt,a);
  }
void PutString(char *line, byte left, byte top, int len, byte attr);
inline void PutString(char *line) {
  gettextinfo(&T);
  PutString(line,T.winleft+T.curx-1,T.wintop+T.cury-1,strlen(line),0);
  }
inline void PutString(char *line, int len, byte attr=0) {
  gettextinfo(&T);
  PutString(line,T.winleft+T.curx-1,T.wintop+T.cury-1,len,attr);
  }

class BL {     //   ப ࠡ祣 ࠭
  VideoText *old;
  void destroy( void )
  {
    if(old)
    {
      PutText(1,T.screenheight,T.screenwidth,1,old);
      delete old;
    }
  }
public:
  BL(char *format,...);
  ~BL(void) { destroy(); }
  void Close( void ){ destroy(); }
};

//   ப ࠡ祣 ࠭ (BL)
extern byte BL_Color[4];

int StrEdit(byte x, byte y, byte l, unsigned ll, char *line,
                            byte eattr=0, byte fattr=0);
inline int StrEdit(byte l, unsigned ll, char *line,
                          byte eattr=0, byte fattr=0) {
  return StrEdit(T.curx,T.cury,l,ll,line,eattr,fattr);
  }
inline int StrEdit(byte l, char *line, byte eattr=0, byte fattr=0) {
  return StrEdit(T.curx,T.cury,l,l,line,eattr,fattr);
  }
byte Warning(char *hdr, char *fmt,...);
void Exit(char *hdr, char *fmt,...);
byte YesNo(TSWIN *w,char *fmt,...);
byte YesExit(TSWIN *w,char *fmt,...);
void TextWindow(char *file_name,char *start_stop);
void TextShow(char *file_name,char *start_stop);
void EditText(char *,char *, char *, int,int,int,int);
void ShowMem(byte attr);

int FileExist(char *);
int FileExistWarning(char *);
char *FileNameCut( char*, char*, int );

void Smooth(int pixel);
void ScanLine(void);
//void Matrix(void);



//=========================  ﭨ ===================
/*
    ﭨ  ( - -) ।祭    ᮧ
- ( ᯮ짮  .  䠩  STATUS.CPP,    ஬
ᠭ 㭪樨-童 ᮢ STAT_ELEM  STATUS)
*/

struct STAT_ELEM
{
  char *Title;
  char *Elem;
  int ID;
  int X, Y;
  int Xe, Ye;

  STAT_ELEM *Next;

  STAT_ELEM();
  STAT_ELEM( int, char*, int, int, int=0, int=0 );
  ~STAT_ELEM();

  int Set( char* );
  void DrawElem( char at ){ PutString( Elem, Xe, Ye, strlen(Elem), at ); }
  void DrawTitle( char at ){ PutString( Title, X, Y, strlen(Title), at ); }

};

class STATUS
{
  STAT_ELEM *E;
  char TitleAttr;
  char ElemAttr;

public:
  STATUS( char ta, char ea ){ E = NULL; TitleAttr = ta; ElemAttr = ea; }
  ~STATUS();

  //   : 䨪,  , न-
  //    ⥪饬 ,  न    ⭮⥫쭮
  // । न ( ᫨ ᫥ ࠬ ==0,  ⭮-
  // ⥫쭮   ).
  int Add( int, char *, int, int, int=0, int=0 );
  // ᮢ  
  void Draw( void );
  //   ᮢ : 䨪, ப 
  int Set( int, char * );

};
