/**********************************************************
          䠩  ⥪ MATRIX.LIB

   ⥪ ᠭ ᪨ ᠭ஬  䥢-
 1994   BORLAND C++ 3.1.

  ⥪ MATRIX.LIB ।祭  祭 ࠡ
 栬.  ।    㯭  ᫥-
騥 樨  栬:

    1) 樠 :
       Matrix A;            - 㫥 樠 (
                               ਭ  㫥 );
       Matrix B( 2, 3, a ); -  2, ਭ 3,    -
                               ᨢ  double a[].
                              (ᨢ    int []).
                              ᫨ a==NULL (  饭 ),
                                  樠
                              ﬨ;
       Matrix E( 4, 4,
              UnitMatrix ); - 樠  筮  -
                                (    -
                              ⭮ );
       Matrix C( B );       - ᮧ    C -
                            筮  B.
       Matrix C = B;

    2) ᢠ :
       Matrix A( 3, 3 );
       Matrix B;
       B = A;               - ᢠ   B  -
                                 ᫠  A.

    3) ᢠ ᨢ:
       double a[]={1.,2.,3.,
                   4.,5.,6.,
                   7.,8.,9.};
       Matrix A( 3, 3 );
       A = a;               -  A   -
                               double a[]. (ᨢ 
                                int [] ).

    4) ᢠ ᫠:
       Matrix A( 3, 4 );
       A = 5.4;             -    A -
                                5.4.

    5)   ⠬ :
       Matrix A( 3, 3, a );
       double *n = A[0];    -  㫥 ப -
                               A;
       double k = A[1][0];  -    ன
                              ப  A;

    6) ᫮, ⠭ :
       Matrix A( 2, 2, a );
       Matrix B( 2, 2, b );
       Matrix C = A + B;    - ⠪  ᭮.
       Matrix D = A - B;    - 筮.

    7) 㬭 :
       Matrix A( 3, 2, a );
       Matrix B( 2, 4, b );
       Matrix C = A * B;    - ⠪  ᭮.
       Matrix D = A * 5.2;  - 㬭   ᫮.

    8)   ⮪:
       Matrix A( 2, 2, a );
       cout << " A:";
       cout << A;           - ८।  ᤢ
                              <<  뢮    -
                              ⮪ ostream.
       cin >> A;            - ८।  ᤢ
                              >>     ⮪
                              istream.

    9) ࠢ :
       Matrix A( 3, 3, a );
       Matrix B = A;
       B = b;
       if( A == B ) ...     - ८।  == 
         else ...             ࠢ .
       if( A != B ) ...     - ८।  != 
         else ...             ࠢ .

   10) ࠭ᯮ஢ :
       Matrix A( 3, 2, a );
       Matrix TA = ~A;      -  ~  ࠭ᯮ -
                              .

___________________________________________________________

ਬ砭:

    1) ᫨ ந諠 訡  㭪樨 ⥪ ( ᫮-
       , ⠭, ᮧ, 㬭, ... ),  
       (訡) 뢮  ⮪ (cout << Error;)   -
       頥  㫥    ᨬ   ࠧ஢
       (᫨  㭪   ).

___________________________________________________________

**********************************************************/

#ifndef MATRIX_H
#define MATRIX_H


enum UNITMATRIX { UnitMatrix };

class Matrix
{
  double **A;                // 
  int width;                 // ਭ
  int height;                // 

  void Init( void );
  void destroy_matrix();

public:
  Matrix(){ width = height = 0; }
  Matrix( int, int, double* =NULL );
  Matrix( int, int, int* );
  Matrix( int );
  Matrix( Matrix &M );
  ~Matrix();
  void destroy( void );

  Matrix &operator=( Matrix& );
  Matrix &operator=( double* );
  Matrix &operator=( int* );
  Matrix &operator=( double );

  double *operator[]( int n ){ return A[n]; }

  void SetSize( int h, int w );
  Matrix *GetColumn( int n );

  friend Matrix *operator+( Matrix&, Matrix& );
  friend Matrix *operator-( Matrix&, Matrix& );

  friend Matrix *operator*( Matrix&, Matrix& );
  friend Matrix *operator*( Matrix&, double );
  friend Matrix *operator*( double, Matrix& );

  friend Matrix *operator+( Matrix&, double );
  friend Matrix *operator+( double, Matrix& );
  friend Matrix *operator-( Matrix&, double );

  friend Matrix *operator~( Matrix& );


  friend ostream &operator<<( ostream&, Matrix& );
  friend istream &operator>>( istream&, Matrix& );

  friend int      operator==( Matrix&, Matrix& );
  friend int      operator!=( Matrix&, Matrix& );

};


#endif


