/*
   ᮤন । 㭪権   Matrix    -
⢥ 㭪権 ⮣ .   䠩 室-
   ⥪ MATRIX.LIB (. MATRIX.H).
*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include "matrix.h"


// ᢮   
void Matrix::destroy_matrix( void )
{
  if( A != NULL )
  {
    for( int i = 0; i < height; i++ ) if( A[i] != NULL ) delete A[i];
    delete A;
    A = NULL; width = height = 0;
  }
}

// ()⠭ ࠧ஢ 
void Matrix::SetSize( int h, int w )
{
  destroy_matrix();

  A = (double **) new char [ h * sizeof(double*) ];
  if( A != NULL )
  {
    for( int i = 0; i < h; i++ )
    {
      A[i] = new double [w];
      if( A[i] == NULL ) break;
    }
    if( i == h )
    {
      height = h; width = w;
      return;
    }
  }
  cout << " 墠⨫   ᮧ  ! "
            "SetSize( int, int ) !\n";
  exit( 1 );
}

void Matrix::Init( void )
{
  A = NULL; width = height = 0;
}

// ஢    ᨢ
Matrix::Matrix( int h, int w, double *a )
{
  Init();
  SetSize( h, w );
  if( a != NULL ) operator=( a );
    else operator=( 0. );
}

// ஢    楫 (int) ᨢ
Matrix::Matrix( int h, int w, int *a )
{
  Init();
  SetSize( h, w );
  if( a != NULL ) operator=( a );
    else operator=( 0. );
}

// ஢ 筮 
Matrix::Matrix( int hw )
{
  Init();
  SetSize( hw, hw );
  for( int i=0; i<height; i++ )
    for( int j=0; j<width; j++ )
      if( i == j ) A[i][j] = 1.;
      else A[i][j] = 0.;
}

// ஢    㣮 
Matrix::Matrix( Matrix &M )
{
  Init();
  operator=( M );
}

// 㭨⮦ ꥪ 
void Matrix::destroy( void )
{
  destroy_matrix();
}

// the same...
Matrix::~Matrix()
{
  destroy();
}

//  ᢠ  ᨢ
Matrix &Matrix::operator=( double *a )
{
  for( int i=0; i<height; i++ )
     for( int j=0; j<width; j++ ) A[i][j] = a[i*width+j];
  return *this;
}

//  ᢠ  楫 (int) ᨢ
Matrix &Matrix::operator=( int *a )
{
  for( int i=0; i<height; i++ )
     for( int j=0; j<width; j++ ) A[i][j] = a[i*width+j];
  return *this;
}

//    ᫮
Matrix &Matrix::operator=( double a )
{
  for( int i=0; i<height; i++ )
     for( int j=0; j<width; j++ ) A[i][j] = a;
  return *this;
}

//  ᢠ  
Matrix &Matrix::operator=( Matrix &M )
{
  SetSize( M.height, M.width );
  for( int i=0; i<height; i++ )
     for( int j=0; j<width; j++ ) A[i][j] = M.A[i][j];
  return *this;
}

//  ᫮ 
Matrix *operator+( Matrix &M1, Matrix &M2 )
{
  if( M1.width != M2.width || M1.height != M2.height )
  {
    cout << "訡 ᫮! ᮮ⢥⢨ ࠧ஢ .\n";
    exit( 1 );
  }
  Matrix *Temp = new Matrix( M1.height, M1.width );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator+(Matrix&, Matrix&)\n";
                      exit( 1 ); }
  for( int i=0; i<M1.height; i++ )
     for( int j=0; j<M1.width; j++ )
        Temp->A[i][j] = M1.A[i][j] + M2.A[i][j];
  return Temp;
}

//  ⠭ 
Matrix *operator-( Matrix &M1, Matrix &M2 )
{
  if( M1.width != M2.width || M1.height != M2.height )
  {
    cout << "訡 ⠭! ᮮ⢥⢨ ࠧ஢ .\n";
    exit( 1 );
  }
  Matrix *Temp = new Matrix( M1.height, M1.width );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator-(Matrix&,Matrix&)\n";
                      exit( 1 ); }
  for( int i=0; i<M1.height; i++ )
     for( int j=0; j<M1.width; j++ )
        Temp->A[i][j] = M1.A[i][j] - M2.A[i][j];
  return Temp;
}

//  㬭 
Matrix *operator*( Matrix &M1, Matrix &M2 )
{
  if( M1.width != M2.height )
  {
    cout << "訡 㬭!!!\n";
    exit( 1 );
  }
  Matrix *Temp = new Matrix( M1.height, M2.width );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator*(Matrix&,Matrix&)\n";
                      exit( 1 ); }
  for( int i=0; i<Temp->height; i++ )
     for( int j=0; j<Temp->width; j++ )
     {
       Temp->A[i][j] = 0;
       for( int k=0; k<M1.width; k++ )
          Temp->A[i][j] += M1.A[i][k]*M2.A[k][j];
     }
  return Temp;
}

//  㬭   ᫮
Matrix *operator*( Matrix &M, double a )
{
  Matrix *Temp = new Matrix( M.height, M.width );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator*(Matrix&,double)\n";
                      exit( 1 ); }
  for( int i=0; i<Temp->height; i++ )
     for( int j=0; j<Temp->width; j++ )
        Temp->A[i][j] = M.A[i][j] * a;
  return Temp;
}

//  ,   ।饥 ⮫쪮 ...
Matrix *operator*( double a, Matrix &M )
{
  return M*a;
}

//  뢮   ⮪
ostream &operator<<( ostream &OS, Matrix &M )
{
  for( int i=0; i<M.height; i++ )
  {
    for( int j=0; j<M.width; j++ )
    {
      char *s = new char [200]; if( s == NULL ) return OS;
      sprintf( s, "%6.3f ", M.A[i][j] );
      OS << s;
      delete s;
    }
    OS << "\n";
  }
  return OS;
}

// ॠ    ⮪
istream &operator>>( istream &IS, Matrix &M )
{
  for( int i=0; i<M.height; i++ )
     for( int j=0; j<M.width; j++ ) IS >> M.A[i][j];
  return IS;
}

//  ࠢ  (頥 1, ᫨  ࠢ)
int operator==( Matrix &M1, Matrix &M2 )
{
  if( M1.width != M2.width || M1.height != M2.height ) return 0;
  for( int i=0; i<M1.height; i++ )
     for( int j=0; j<M1.width; j++ )
        if( M1.A[i][j] != M2.A[i][j] ) return 0;
  return 1;
}

//  ࠢ  (頥 1, ᫨   ࠢ)
int operator!=( Matrix &M1, Matrix &M2 )
{
  if( M1.width != M2.width || M1.height != M2.height ) return 1;
  for( int i=0; i<M1.height; i++ )
     for( int j=0; j<M1.width; j++ )
        if( M1.A[i][j] != M2.A[i][j] ) return 1;
  return 0;
}

//  ࠭ᯮ஢ 
Matrix *operator~( Matrix &M )
{
  Matrix *Temp = new Matrix( M.width, M.height );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator~(Matrix&)\n";
                      exit( 1 ); }

  for( int i=0; i< M.height; i++ )
     for( int j=0; j< M.width; j++ ) Temp->A[j][i] = M.A[i][j];
  return Temp;
}

Matrix *operator+( Matrix &M, double a )
{
  Matrix *Temp = new Matrix( M.width, M.height );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator+(Matrix&,double)\n";
                      exit( 1 ); }
  for( int i = 0; i < M.height; i++ )
    for( int j = 0; j < M.width; j++ )
      Temp->A[i][j] = M.A[i][j] + a;
  return Temp;
}

Matrix *operator+( double a, Matrix &M )
{
  return operator+( M, a );
}

Matrix *operator-( Matrix &M, double a )
{
  return operator+( M, -a );
}

Matrix *Matrix::GetColumn( int n )
{
  Matrix *Temp = new Matrix( height, 1 );
  if( Temp == NULL ){ cout << "   ᮧ !\n"
                              "operator~(Matrix&)\n";
                      exit( 1 ); }
  for( int i = 0; i < height; i++ ) Temp->A[i][0] = A[i][n];
  return Temp;
}
