typedef int* ptr_int;
class matrix             //  
{
   public:
      ptr_int *b;
      int x,y;      // ࠧ 
      matrix(){}    //   㬮砭
      matrix(int,int);   //   ࠬࠬ
      matrix(const matrix& m);  //  
      sqr_matr(int);    // ⨯  ⭮ 
      ~matrix();        // 
	   // ॣ㦥 : =,+,*
      matrix& operator=(const matrix&);
      matrix operator+(const matrix&);
      matrix operator*(const matrix&);

      void input(int,int);  //  
      void print(int,int);  // 뢮 
      void error(int);      // ᮮ饭  訡
};
matrix::matrix(int x1, int y1): x(x1),y(y1)
{
   b=new ptr_int [x];
   for(int i=0;i<x;i++) b[i]=new int[y];
}
matrix::matrix(const matrix& m)
{
   int i,j;
   b=new ptr_int [m.x];
   for(i=0;i<m.x;i++) b[i]=new int[m.y];
   x=m.x;
   y=m.y;
   for(i=0;i<x;i++)
   for(j=0;j<y;j++)
   {
      b[i][j]=m.b[i][j];
   }
}
matrix::~matrix()
{
   for(int i=0;i<x;i++) delete  b[i];
   delete  b;
}
matrix& matrix::operator=(const matrix& m)
{
   int i,j;
   if(x!=m.x || y!=m.y) error(1);
   for(i=0;i<x;i++)
      for(j=0;j<y;j++)
      {
	 b[i][j]=m.b[i][j];
      }
   return(*this);
}
matrix matrix::operator+(const matrix& m)
{
   int i,j;
   if(x!=m.x || y!=m.y) error(2);
   matrix s(x,y);
   for(i=0;i<x;i++)
      for(j=0;j<y;j++)
      {
	 s.b[i][j]=b[i][j]+m.b[i][j];
      }
   return(s);
}
matrix matrix::operator*(const matrix& m)
{
   int i,j,k,q;
   if(x!=m.y) error(3);
   matrix s(m.x,y);
   for(i=0;i<m.x;i++)
      for(j=0;j<y;j++)
      {
	 q=0;
	 for(k=0;k<x;k++)
	 {
	    q+=b[k][j]*m.b[i][k];
	 }
	 s.b[i][j]=q;
      }
   return(s);
}
void matrix::input(int kx,int ky)
{
   int i,j;
   gotoxy(kx,ky);
   cout<<" :";
   for(j=0;j<y;j++)
   {
      for(i=0;i<x;i++)
      {
	 gotoxy(kx+i*12,ky+j+1);
	 cout<<"b["<<i<<"]["<<j<<"]=";
	 cin>>b[i][j];
	 cout<<"  ";
      }
   }
}
void matrix::print(int kx, int ky)
{
   int i,j;
   gotoxy(kx,ky);
   cout<<":";
   for(j=0;j<y;j++)
   {
      for(i=0;i<x;i++)
      {
	 gotoxy(kx+i*10+1,ky+j+1);
	 cout<<b[i][j];
      }
   }
}
void matrix::error(int i)
{
   switch(i)
   {
      case 1: cout<<" ᮢ ࠧ    ᢠ";
	      break;
      case 2: cout<<" ᮢ ࠧ    ᫮";
	      break;
      case 3: cout<<" ࠧ    㬭";
	      break;
      default:;
   }
   exit(1);
}

class sqr_matr: public matrix   //  ⭠ 
{
   public:
   sqr_matr(int);      // 
   int det();          // ।⥫ 
};
sqr_matr::sqr_matr(int x1)
{
   x=x1;
   y=x1;
   b=new ptr_int [x];
   for(int i=0;i<x;i++) b[i]=new int[x];
}
int minor(sqr_matr q, int v)
{
   int opred(sqr_matr);
   int i,j,k;
   sqr_matr m(q.x-1);
   for(i=0,k=0;i<m.x;i++,k++)
   {
      if(k==v) k++;
      for(j=0;j<m.y;j++)
      {
	 m.b[i][j]=q.b[k][j+1];
      }
   }
   return(opred(m));
}
int opred(sqr_matr p)
{
   int i,s=0;
   if(p.x==1) return(p.b[0][0]);
   for(i=0;i<p.x;i++)
   {
      s+=((i%2)?-1:1)*p.b[i][0]*minor(p,i);
   }
   return(s);
}
int sqr_matr::det()
{
   
   return(opred(*this));
}
