unit Vid;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Grids, DBGrids, DB, DBTables;

type
  TVidForm = class(TForm)
    DataSource1: TDataSource;
    Table1: TTable;
    DBGrid1: TDBGrid;
    Bevel1: TBevel;
    AddBtn: TBitBtn;
    RefreshBtn: TBitBtn;
    DelBtn: TBitBtn;
    CloseBtn: TBitBtn;
    Bevel2: TBevel;
    Label1: TLabel;
    NumEdit: TEdit;
    Label2: TLabel;
    TextEdit: TEdit;
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
  private
    { Private declarations }
    s : String ;
  public
    { Public declarations }
  end;

var
  VidForm: TVidForm;

implementation

{$R *.DFM}

procedure TVidForm.CloseBtnClick(Sender: TObject);
begin
  Table1.Active := False;
  Close;
end;

procedure TVidForm.FormCreate(Sender: TObject);
begin
  Table1.Active := True;
  WITH Table1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('VID').DisplayLabel := ' ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('VID').DisplayWidth := 50;
END;

end;

procedure TVidForm.FormActivate(Sender: TObject);
begin
  Table1.Active := True;
  WITH Table1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('VID').DisplayLabel := ' ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('VID').DisplayWidth := 50;
END;

end;

procedure TVidForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(TextEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH Table1 DO
    BEGIN
      s := NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, TextEdit.Text] );

 {  }
 NumEdit.Text :='';
 TextEdit.Text :='';
 END;


end;

procedure TVidForm.RefreshBtnClick(Sender: TObject);
begin
  WITH Table1 DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;

end;

procedure TVidForm.DelBtnClick(Sender: TObject);
begin
  WITH Table1 DO
    BEGIN
     IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;

end;

procedure TVidForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN
  WITH Table1 DO
    BEGIN
     IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;
END;

end;

end.
