unit Qualif;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, DBGrids, ExtCtrls, DB, DBTables, StdCtrls, Buttons;

type
  TQualifForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    QualifEdit: TEdit;
    QualifSource: TDataSource;
    QualifTable: TTable;
    DBGrid1: TDBGrid;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    CloseBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String;
  public
    { Public declarations }
  end;

var
  QualifForm: TQualifForm;

implementation

{$R *.DFM}


procedure TQualifForm.FormCreate(Sender: TObject);
begin
   QualifTable.Active := True;
  WITH QualifTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('QUALIFICATE').DisplayLabel := '';
     FieldByName('QUALIFICATE').DisplayWidth := 35;
    END;

end;
procedure TQualifForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(QualifEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH QualifTable DO
    BEGIN
     s :=  NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, QualifEdit.Text] );

 {  }
 NumEdit.Text :='';
 QualifEdit.Text :='';
 END;

end;

procedure TQualifForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 QualifEdit.Text :='';

end;

procedure TQualifForm.RefreshBtnClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN

 WITH QualifTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TQualifForm.CloseBtnClick(Sender: TObject);
begin
QualifTable.Active := False;
Close;
end;





procedure TQualifForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN
  WITH QualifTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TQualifForm.FormActivate(Sender: TObject);
begin
QualifTable.Active := True;
end;

end.
