unit Predpr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, DBGrids, DB, DBTables, Buttons;

type
  TPredprForm = class(TForm)
    AddBtn: TSpeedButton;
    CanselBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    CloseBtn: TSpeedButton;
    PredprSource: TDataSource;
    PredprTable: TTable;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    NumEdit: TEdit;
    Label2: TLabel;
    PredprEdit: TEdit;
    procedure AddBtnClick(Sender: TObject);
    procedure CanselBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
     s : String;
  public
    { Public declarations }
  end;

var
  PredprForm: TPredprForm;

implementation

{$R *.DFM}
procedure TPredprForm.AddBtnClick(Sender: TObject);
begin
 IF (Length(NumEdit.Text)=0)AND
   (Length(PredprEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH PredprTable DO
    BEGIN
     s :=  NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, PredprEdit.Text] );

 {  }
 NumEdit.Text :='';
 PredprEdit.Text :='';
 END;

end;

procedure TPredprForm.CanselBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 PredprEdit.Text :='';

end;

procedure TPredprForm.CloseBtnClick(Sender: TObject);
begin
PredprTable.Active := False;
Close;
end;

procedure TPredprForm.FormCreate(Sender: TObject);
begin
PredprTable.Active := True;
 WITH PredprTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('FACTORY').DisplayLabel := '';
     FieldByName('FACTORY').DisplayWidth := 50;
    END;
  END;
procedure TPredprForm.RefreshBtnClick(Sender: TObject);
begin
 WITH PredprTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;


end;


procedure TPredprForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN

 WITH PredprTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TPredprForm.FormActivate(Sender: TObject);
begin
PredprTable.Active := True;
end;

end.
