unit Otpusk;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, DBTables, Grids, DBGrids,
  DBLookup, ExtCtrls;

type
  TOtpuskForm = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    NumEdit: TEdit;
    PeriodEdit: TEdit;
    DataNEdit: TEdit;
    DataOEdit: TEdit;
    OsnovanieEdit: TEdit;
    DBLookupCombo1: TDBLookupCombo;
    DBGrid1: TDBGrid;
    DataSourceOtpusk: TDataSource;
    DataSourceVid: TDataSource;
    TableOtpusk: TTable;
    TableVid: TTable;
    AddBtn: TBitBtn;
    DelBtn: TBitBtn;
    CloseBtn: TBitBtn;
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure DelBtnClick(Sender: TObject);
    procedure DBGrid1ColEnter(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  OtpuskForm: TOtpuskForm;

implementation

{$R *.DFM}

procedure TOtpuskForm.CloseBtnClick(Sender: TObject);
begin
  TableVid.Active := False;
  TableOtpusk.Active := False;

Close;
end;

procedure TOtpuskForm.FormCreate(Sender: TObject);
begin
  TableVid.Active := True;
  TableOtpusk.Active := True;
  WITH TableOtpusk DO
    BEGIN
    FieldByName('NUM').DisplayLabel := ' ';
    FieldByName('NUM').DisplayWidth := 17;
    FieldByName('DATAn.o.').DisplayLabel := '  ';
    FieldByName('DATAn.o.').DisplayWidth := 20;
    FieldByName('DATAo.o.').DisplayLabel := '  ';
    FieldByName('DATAo.o.').DisplayWidth := 20;
    FieldByName('PERIOD').DisplayWidth := 10;
    FieldByName('PERIOD').DisplayLabel := '';
    FieldByName('OTPUSK').DisplayWidth := 4;
    FieldByName('OTPUSK').DisplayLabel := '';
    FieldByName('OSNOVANIE').DisplayWidth := 30;
    FieldByName('OSNOVANIE').DisplayLabel := '';
  END;

end;

procedure TOtpuskForm.FormActivate(Sender: TObject);
begin
  TableVid.Active := True;
  TableOtpusk.Active := True;
  WITH TableOtpusk DO
    BEGIN
    FieldByName('NUM').DisplayLabel := ' ';
    FieldByName('NUM').DisplayWidth := 17;
    FieldByName('DATAn.o.').DisplayLabel := '  ';
    FieldByName('DATAn.o.').DisplayWidth := 20;
    FieldByName('DATAo.o.').DisplayLabel := '  ';
    FieldByName('DATAo.o.').DisplayWidth := 20;
    FieldByName('PERIOD').DisplayWidth := 10;
    FieldByName('PERIOD').DisplayLabel := '';
    FieldByName('OTPUSK').DisplayWidth := 4;
    FieldByName('OTPUSK').DisplayLabel := '';
    FieldByName('OSNOVANIE').DisplayWidth := 30;
    FieldByName('OSNOVANIE').DisplayLabel := '';
  END;

end;

procedure TOtpuskForm.AddBtnClick(Sender: TObject);
begin
  WITH TableOtpusk DO
    BEGIN


               InsertRecord([NumEdit.Text,
                   TableVid.Fields[0].asInteger,
                   PeriodEdit.Text,
                   DataNEdit.Text,
                   DataOEdit.Text,
                   OsnovanieEdit.Text] );


{  }
 NumEdit.Text :='';
 DataNEdit.Text :='';
 DataOEdit.Text :='';
 PeriodEdit.Text :='';
 OsnovanieEdit.Text := '';
  END;

end;

procedure TOtpuskForm.DelBtnClick(Sender: TObject);
begin
  WITH TableOtpusk DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;

end;

procedure TOtpuskForm.DBGrid1ColEnter(Sender: TObject);
begin
  WITH TableOtpusk DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;

end;

end.
