unit Nation;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, Grids, DBGrids, DB, DBTables;

type
  TNationForm = class(TForm)
    NationSource: TDataSource;
    NationTable: TTable;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    NationEdit: TEdit;
    AddBtn: TSpeedButton;
    CanselBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    CloseBtn: TSpeedButton;
    procedure AddBtnClick(Sender: TObject);
    procedure CanselBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
     s : String;
  public
    { Public declarations }
  end;

var
  NationForm: TNationForm;

implementation

{$R *.DFM}

procedure TNationForm.AddBtnClick(Sender: TObject);
begin
 IF (Length(NumEdit.Text)=0)AND
   (Length(NationEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH NationTable DO
    BEGIN
     s :=  NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, NationEdit.Text] );

 {  }
 NumEdit.Text :='';
 NationEdit.Text :='';
 END;

end;

procedure TNationForm.CanselBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 NationEdit.Text :='';

end;

procedure TNationForm.CloseBtnClick(Sender: TObject);
begin
NationTable.Active := False;
Close;
end;

procedure TNationForm.FormCreate(Sender: TObject);
begin
NationTable.Active := True;
 WITH NationTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('Nation').DisplayLabel := '';
     FieldByName('Nation').DisplayWidth := 35;
    END;

end;

procedure TNationForm.RefreshBtnClick(Sender: TObject);
begin
 WITH NationTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;


end;

procedure TNationForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN

 WITH NationTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TNationForm.FormActivate(Sender: TObject);
begin
NationTable.Active := True;
end;

end.
