unit Nameed;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, DBGrids, DB, DBTables, ExtCtrls, StdCtrls, Buttons;

type
  TNameEdForm = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    NameEdit: TEdit;
    NameEdSource: TDataSource;
    NameEdTable: TTable;
    DBGrid1: TDBGrid;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    EndBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure EndBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String;
  public
    { Public declarations }
  end;

var
  NameEdForm: TNameEdForm;

implementation

{$R *.DFM}


procedure TNameEdForm.FormCreate(Sender: TObject);
begin
NameEdTable.Active := True;


 WITH NameEdTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('Name').DisplayLabel := ' . ';
     FieldByName('Name').DisplayWidth := 35;
    END;


end;


procedure TNameEdForm.AddBtnClick(Sender: TObject);
begin
 IF (Length(NumEdit.Text)=0)AND
   (Length(NameEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH NameEdTable DO
    BEGIN
     s :=  NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, NameEdit.Text] );

 {  }
 NumEdit.Text :='';
 NameEdit.Text :='';
 END;


end;

procedure TNameEdForm.EndBtnClick(Sender: TObject);
begin
NameEdTable.Active := False;
Close;
end;

procedure TNameEdForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 NameEdit.Text :='';

end;

procedure TNameEdForm.RefreshBtnClick(Sender: TObject);
begin
 WITH NameEdTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;


end;

procedure TNameEdForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN

 WITH NameEdTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;
end;

procedure TNameEdForm.FormActivate(Sender: TObject);
begin
NameEdTable.Active := True;
end;

end.
