unit Educate;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DB, DBTables,
  Buttons;

type
  TEdForm = class(TForm)
    EducatSource1: TDataSource;
    EducatTable1: TTable;
    DBGrid1: TDBGrid;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    TextEdit: TEdit;
    CloseBtn: TSpeedButton;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    procedure DBGrid1ColEnter(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String;
  public
    { Public declarations }
  end;

var
  EdForm: TEdForm;

implementation

{$R *.DFM}


procedure TEdForm.DBGrid1ColEnter(Sender: TObject);
begin
WITH EducatTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('EDUCAT').DisplayLabel := '';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('EDUCAT').DisplayWidth := 50;
END;
end;


procedure TEdForm.FormCreate(Sender: TObject);
begin
EducatTable1.Active := True;
WITH EducatTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('EDUCAT').DisplayLabel := '';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('EDUCAT').DisplayWidth := 50;
END;

end;


procedure TEdForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(TextEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH EducatTable1 DO
    BEGIN
      s := NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, TextEdit.Text] );

 {  }
 NumEdit.Text :='';
 TextEdit.Text :='';
 END;


end;

procedure TEdForm.CloseBtnClick(Sender: TObject);
begin
EducatTable1.Active := False;
Close;
end;

procedure TEdForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 TextEdit.Text :='';

end;

procedure TEdForm.RefreshBtnClick(Sender: TObject);
begin
  WITH EducatTable1 DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;

end;

procedure TEdForm.DBGrid1DblClick(Sender: TObject);
begin
WITH DBGrid1.SelectedField DO
 BEGIN
  WITH EducatTable1 DO
    BEGIN
     IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;
END;
end;

procedure TEdForm.FormActivate(Sender: TObject);
begin
EducatTable1.Active := True;
end;

end.
