unit Zvanie;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Grids, DBGrids, Buttons;

type
  TVoinForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    CloseBtn: TSpeedButton;
    AddBtn: TSpeedButton;
    CancelBtn: TSpeedButton;
    RefreshBtn: TSpeedButton;
    DBGrid1: TDBGrid;
    NumEdit: TEdit;
    TextEdit: TEdit;
    ZvanSource1: TDataSource;
    ZvanTable1: TTable;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure CloseBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
  private
    { Private declarations }
    s : String ;
  public
    { Public declarations }
  end;

var
  VoinForm: TVoinForm;

implementation

{$R *.DFM}

procedure TVoinForm.FormCreate(Sender: TObject);
begin
ZvanTable1.Active := True;
WITH ZvanTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('ZVAN').DisplayLabel := ' ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('ZVAN').DisplayWidth := 50;
end;
END;

procedure TVoinForm.AddBtnClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(TextEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH ZvanTable1 DO
    BEGIN
      s := NumEdit.Text;
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, TextEdit.Text] );

 {  }
 NumEdit.Text :='';
 TextEdit.Text :='';
 END;



end;

procedure TVoinForm.CancelBtnClick(Sender: TObject);
begin
 NumEdit.Text :='';
 TextEdit.Text :='';

end;

procedure TVoinForm.RefreshBtnClick(Sender: TObject);
begin
  WITH ZvanTable1 DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }
END;


end;

procedure TVoinForm.CloseBtnClick(Sender: TObject);
begin
ZvanTable1.Active := False;
Close;
end;

procedure TVoinForm.FormActivate(Sender: TObject);
begin
ZvanTable1.Active := True;
WITH ZvanTable1 DO
BEGIN
  FieldByName('NUM').DisplayLabel := '';
  FieldByName('ZVAN').DisplayLabel := ' ';
  FieldByName('NUM').DisplayWidth := 5;
  FieldByName('ZVAN').DisplayWidth := 50;
end;
end;


procedure TVoinForm.DBGrid1DblClick(Sender: TObject);
begin
  WITH ZvanTable1 DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([s]) THEN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{   }

END;
end;

end.
