unit Spetial;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, DBGrids, DB, DBTables, ExtCtrls, StdCtrls;

type
  TSpetialForm = class(TForm)
    Panel1: TPanel;
    AddButton: TButton;
    CloseButton: TButton;
    Label1: TLabel;
    Label2: TLabel;
    NumEdit: TEdit;
    SpetialEdit: TEdit;
    SourceSpetial: TDataSource;
    SpetialTable: TTable;
    DBGrid1: TDBGrid;
    procedure AddButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
    s : String;
  public
    { Public declarations }
  end;

var
  SpetialForm: TSpetialForm;

implementation

{$R *.DFM}

procedure TSpetialForm.AddButtonClick(Sender: TObject);
begin
IF (Length(NumEdit.Text)=0)AND
   (Length(SpetialEdit.Text)=0)
THEN
   MessageDlg('   !', mtError, [mbCancel], 0)
ELSE
  WITH SpetialTable DO
    BEGIN
     IndexFieldNames := 'NUM';
     IF FindKey([NumEdit.Text]) THEN
        MessageDlg(' !', mtError, [mbCancel], 0)
     ELSE
     InsertRecord([NumEdit.Text, SpetialEdit.Text] );

 {  }
 NumEdit.Text :='';
 SpetialEdit.Text :='';
 END;

end;

procedure TSpetialForm.CloseButtonClick(Sender: TObject);
begin
SpetialTable.Active := False;
Close;
end;

procedure TSpetialForm.FormCreate(Sender: TObject);
begin
  SpetialTable.Active := True;
 WITH SpetialTable DO
    BEGIN
     FieldByName('NUM').DisplayLabel := '';
     FieldByName('NUM').DisplayWidth := 5;
     FieldByName('Spetial').DisplayLabel := '  ';
     FieldByName('Spetial').DisplayWidth := 35;
    END;


end;

procedure TSpetialForm.DBGrid1DblClick(Sender: TObject);

begin
WITH DBGrid1.SelectedField DO
 BEGIN
  WITH SpetialTable DO
    BEGIN
       IF MessageDlg(' ,     ?!',
                      mtConfirmation, [mbYes, mbNo], 0)
                      = mrYes THEN Delete;{  }
END;
END;

end;

procedure TSpetialForm.FormActivate(Sender: TObject);
begin
SpetialTable.Active := True;
end;

end.
